/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.ode.FieldEquationsMapper;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.FieldExplicitRungeKuttaIntegrator;
import org.hipparchus.ode.nonstiff.FixedStepRungeKuttaFieldIntegrator;
import org.hipparchus.ode.nonstiff.interpolators.LutherFieldStateInterpolator;
import org.hipparchus.util.MathArrays;

public class LutherFieldIntegrator<T extends CalculusFieldElement<T>>
extends FixedStepRungeKuttaFieldIntegrator<T> {
    public static final String METHOD_NAME = "Luther";

    public LutherFieldIntegrator(Field<T> field, T step) {
        super(field, METHOD_NAME, step);
    }

    @Override
    public T[] getC() {
        CalculusFieldElement q = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getField().getZero()).add(21.0)).sqrt();
        CalculusFieldElement[] c = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)6);
        c[0] = (CalculusFieldElement)this.getField().getOne();
        c[1] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1, 2);
        c[2] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 2, 3);
        c[3] = (CalculusFieldElement)((CalculusFieldElement)q.subtract(7.0)).divide(-14.0);
        c[4] = (CalculusFieldElement)((CalculusFieldElement)q.add(7.0)).divide(14.0);
        c[5] = (CalculusFieldElement)this.getField().getOne();
        return c;
    }

    @Override
    public T[][] getA() {
        CalculusFieldElement q = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)this.getField().getZero()).add(21.0)).sqrt();
        CalculusFieldElement[][] a = (CalculusFieldElement[][])MathArrays.buildArray(this.getField(), (int)6, (int)-1);
        for (int i = 0; i < a.length; ++i) {
            a[i] = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)(i + 1));
        }
        a[0][0] = (CalculusFieldElement)this.getField().getOne();
        a[1][0] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 3, 8);
        a[1][1] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1, 8);
        a[2][0] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 8, 27);
        a[2][1] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 2, 27);
        a[2][2] = a[2][0];
        a[3][0] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q.multiply(9)).add(-21.0)).divide(392.0);
        a[3][1] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q.multiply(8)).add(-56.0)).divide(392.0);
        a[3][2] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q.multiply(-48)).add(336.0)).divide(392.0);
        a[3][3] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q.multiply(3)).add(-63.0)).divide(392.0);
        a[4][0] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q.multiply(-255)).add(-1155.0)).divide(1960.0);
        a[4][1] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q.multiply(-40)).add(-280.0)).divide(1960.0);
        a[4][2] = (CalculusFieldElement)((CalculusFieldElement)q.multiply(-320)).divide(1960.0);
        a[4][3] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q.multiply(363)).add(63.0)).divide(1960.0);
        a[4][4] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q.multiply(392)).add(2352.0)).divide(1960.0);
        a[5][0] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q.multiply(105)).add(330.0)).divide(180.0);
        a[5][1] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 2, 3);
        a[5][2] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q.multiply(280)).add(-200.0)).divide(180.0);
        a[5][3] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q.multiply(-189)).add(126.0)).divide(180.0);
        a[5][4] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q.multiply(-126)).add(-686.0)).divide(180.0);
        a[5][5] = (CalculusFieldElement)((CalculusFieldElement)((CalculusFieldElement)q.multiply(-70)).add(490.0)).divide(180.0);
        return a;
    }

    @Override
    public T[] getB() {
        CalculusFieldElement[] b = (CalculusFieldElement[])MathArrays.buildArray(this.getField(), (int)7);
        b[0] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 1, 20);
        b[1] = (CalculusFieldElement)this.getField().getZero();
        b[2] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 16, 45);
        b[3] = (CalculusFieldElement)this.getField().getZero();
        b[4] = FieldExplicitRungeKuttaIntegrator.fraction(this.getField(), 49, 180);
        b[5] = b[4];
        b[6] = b[0];
        return b;
    }

    @Override
    protected LutherFieldStateInterpolator<T> createInterpolator(boolean forward, T[][] yDotK, FieldODEStateAndDerivative<T> globalPreviousState, FieldODEStateAndDerivative<T> globalCurrentState, FieldEquationsMapper<T> mapper) {
        return new LutherFieldStateInterpolator(this.getField(), forward, yDotK, globalPreviousState, globalCurrentState, globalPreviousState, globalCurrentState, mapper);
    }
}

