/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.FieldElement;
import org.hipparchus.ode.FieldExpandableODE;
import org.hipparchus.ode.FieldODEIntegrator;
import org.hipparchus.ode.FieldOrdinaryDifferentialEquation;
import org.hipparchus.ode.nonstiff.FieldButcherArrayProvider;
import org.hipparchus.util.MathArrays;

public interface FieldExplicitRungeKuttaIntegrator<T extends CalculusFieldElement<T>>
extends FieldButcherArrayProvider<T>,
FieldODEIntegrator<T> {
    default public double[] getRealC() {
        CalculusFieldElement[] c = this.getC();
        double[] cReal = new double[c.length];
        for (int i = 0; i < c.length; ++i) {
            cReal[i] = c[i].getReal();
        }
        return cReal;
    }

    default public double[][] getRealA() {
        CalculusFieldElement[][] a = this.getA();
        double[][] aReal = new double[a.length][];
        for (int i = 0; i < a.length; ++i) {
            aReal[i] = new double[a[i].length];
            for (int j = 0; j < aReal[i].length; ++j) {
                aReal[i][j] = a[i][j].getReal();
            }
        }
        return aReal;
    }

    default public double[] getRealB() {
        CalculusFieldElement[] b = this.getB();
        double[] bReal = new double[b.length];
        for (int i = 0; i < b.length; ++i) {
            bReal[i] = b[i].getReal();
        }
        return bReal;
    }

    public boolean isUsingFieldCoefficients();

    default public int getNumberOfStages() {
        return this.getB().length;
    }

    default public T[] singleStep(FieldOrdinaryDifferentialEquation<T> equations, T t0, T[] y0, T t) {
        int stages = this.getNumberOfStages();
        CalculusFieldElement[][] yDotK = (CalculusFieldElement[][])MathArrays.buildArray((Field)t0.getField(), (int)stages, (int)-1);
        CalculusFieldElement h = (CalculusFieldElement)t.subtract(t0);
        FieldExpandableODE<T> fieldExpandableODE = new FieldExpandableODE<T>(equations);
        yDotK[0] = fieldExpandableODE.computeDerivatives((CalculusFieldElement)t0, (CalculusFieldElement[])y0);
        if (this.isUsingFieldCoefficients()) {
            FieldExplicitRungeKuttaIntegrator.applyInternalButcherWeights(fieldExpandableODE, t0, y0, (CalculusFieldElement)h, (CalculusFieldElement[][])this.getA(), (CalculusFieldElement[])this.getC(), (CalculusFieldElement[][])yDotK);
            return FieldExplicitRungeKuttaIntegrator.applyExternalButcherWeights(y0, (CalculusFieldElement[][])yDotK, (CalculusFieldElement)h, (CalculusFieldElement[])this.getB());
        }
        FieldExplicitRungeKuttaIntegrator.applyInternalButcherWeights(fieldExpandableODE, t0, y0, (CalculusFieldElement)h, (double[][])this.getRealA(), (double[])this.getRealC(), (CalculusFieldElement[][])yDotK);
        return FieldExplicitRungeKuttaIntegrator.applyExternalButcherWeights(y0, (CalculusFieldElement[][])yDotK, (CalculusFieldElement)h, (double[])this.getRealB());
    }

    public static <T extends CalculusFieldElement<T>> T fraction(Field<T> field, int p, int q) {
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        return (T)((CalculusFieldElement)((CalculusFieldElement)zero.newInstance((double)p)).divide((FieldElement)((CalculusFieldElement)zero.newInstance((double)q))));
    }

    public static <T extends CalculusFieldElement<T>> T fraction(Field<T> field, double p, double q) {
        CalculusFieldElement zero = (CalculusFieldElement)field.getZero();
        return (T)((CalculusFieldElement)((CalculusFieldElement)zero.newInstance(p)).divide((FieldElement)((CalculusFieldElement)zero.newInstance(q))));
    }

    public static <T extends CalculusFieldElement<T>> void applyInternalButcherWeights(FieldExpandableODE<T> equations, T t0, T[] y0, T h, T[][] a, T[] c, T[][] yDotK) {
        int stages = c.length + 1;
        CalculusFieldElement[] yTmp = (CalculusFieldElement[])y0.clone();
        for (int k = 1; k < stages; ++k) {
            for (int j = 0; j < y0.length; ++j) {
                CalculusFieldElement sum = (CalculusFieldElement)yDotK[0][j].multiply(a[k - 1][0]);
                for (int l = 1; l < k; ++l) {
                    sum = (CalculusFieldElement)sum.add((FieldElement)((CalculusFieldElement)yDotK[l][j].multiply(a[k - 1][l])));
                }
                yTmp[j] = (CalculusFieldElement)y0[j].add((FieldElement)((CalculusFieldElement)h.multiply((FieldElement)sum)));
            }
            yDotK[k] = equations.computeDerivatives((CalculusFieldElement)t0.add((FieldElement)((CalculusFieldElement)h.multiply(c[k - 1]))), yTmp);
        }
    }

    public static <T extends CalculusFieldElement<T>> void applyInternalButcherWeights(FieldExpandableODE<T> equations, T t0, T[] y0, T h, double[][] a, double[] c, T[][] yDotK) {
        int stages = c.length + 1;
        CalculusFieldElement[] yTmp = (CalculusFieldElement[])y0.clone();
        for (int k = 1; k < stages; ++k) {
            for (int j = 0; j < y0.length; ++j) {
                CalculusFieldElement sum = (CalculusFieldElement)yDotK[0][j].multiply(a[k - 1][0]);
                for (int l = 1; l < k; ++l) {
                    sum = (CalculusFieldElement)sum.add((FieldElement)((CalculusFieldElement)yDotK[l][j].multiply(a[k - 1][l])));
                }
                yTmp[j] = (CalculusFieldElement)y0[j].add((FieldElement)((CalculusFieldElement)h.multiply((FieldElement)sum)));
            }
            yDotK[k] = equations.computeDerivatives((CalculusFieldElement)t0.add((FieldElement)((CalculusFieldElement)h.multiply(c[k - 1]))), yTmp);
        }
    }

    public static <T extends CalculusFieldElement<T>> T[] applyExternalButcherWeights(T[] y0, T[][] yDotK, T h, T[] b) {
        CalculusFieldElement[] y = (CalculusFieldElement[])y0.clone();
        int stages = b.length;
        for (int j = 0; j < y0.length; ++j) {
            CalculusFieldElement sum = (CalculusFieldElement)yDotK[0][j].multiply(b[0]);
            for (int l = 1; l < stages; ++l) {
                sum = (CalculusFieldElement)sum.add((FieldElement)((CalculusFieldElement)yDotK[l][j].multiply(b[l])));
            }
            y[j] = (CalculusFieldElement)y[j].add((FieldElement)((CalculusFieldElement)h.multiply((FieldElement)sum)));
        }
        return y;
    }

    public static <T extends CalculusFieldElement<T>> T[] applyExternalButcherWeights(T[] y0, T[][] yDotK, T h, double[] b) {
        CalculusFieldElement[] y = (CalculusFieldElement[])y0.clone();
        int stages = b.length;
        for (int j = 0; j < y0.length; ++j) {
            CalculusFieldElement sum = (CalculusFieldElement)yDotK[0][j].multiply(b[0]);
            for (int l = 1; l < stages; ++l) {
                sum = (CalculusFieldElement)sum.add((FieldElement)((CalculusFieldElement)yDotK[l][j].multiply(b[l])));
            }
            y[j] = (CalculusFieldElement)y[j].add((FieldElement)((CalculusFieldElement)h.multiply((FieldElement)sum)));
        }
        return y;
    }
}

