/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.nonstiff;

import java.util.Arrays;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealMatrixPreservingVisitor;
import org.hipparchus.ode.EquationsMapper;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.nonstiff.AdamsIntegrator;
import org.hipparchus.ode.nonstiff.StepsizeHelper;
import org.hipparchus.ode.nonstiff.interpolators.AdamsStateInterpolator;
import org.hipparchus.util.FastMath;

public class AdamsMoultonIntegrator
extends AdamsIntegrator {
    public static final String METHOD_NAME = "Adams-Moulton";

    public AdamsMoultonIntegrator(int nSteps, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) throws MathIllegalArgumentException {
        super(METHOD_NAME, nSteps, nSteps + 1, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
    }

    public AdamsMoultonIntegrator(int nSteps, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) throws IllegalArgumentException {
        super(METHOD_NAME, nSteps, nSteps + 1, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
    }

    @Override
    protected double errorEstimation(double[] previousState, double predictedTime, double[] predictedState, double[] predictedScaled, RealMatrix predictedNordsieck) {
        double error = predictedNordsieck.walkInOptimizedOrder((RealMatrixPreservingVisitor)new Corrector(previousState, predictedScaled, predictedState));
        if (Double.isNaN(error)) {
            throw new MathIllegalStateException((Localizable)LocalizedODEFormats.NAN_APPEARING_DURING_INTEGRATION, new Object[]{predictedTime});
        }
        return error;
    }

    @Override
    protected AdamsStateInterpolator finalizeStep(double stepSize, double[] predictedState, double[] predictedScaled, Array2DRowRealMatrix predictedNordsieck, boolean isForward, ODEStateAndDerivative globalPreviousState, ODEStateAndDerivative globalCurrentState, EquationsMapper equationsMapper) {
        double[] correctedYDot = this.computeDerivatives(globalCurrentState.getTime(), predictedState);
        double[] correctedScaled = new double[predictedState.length];
        for (int j = 0; j < correctedScaled.length; ++j) {
            correctedScaled[j] = this.getStepSize() * correctedYDot[j];
        }
        this.updateHighOrderDerivativesPhase2(predictedScaled, correctedScaled, predictedNordsieck);
        ODEStateAndDerivative updatedStepEnd = equationsMapper.mapStateAndDerivative(globalCurrentState.getTime(), predictedState, correctedYDot);
        return new AdamsStateInterpolator(this.getStepSize(), updatedStepEnd, correctedScaled, predictedNordsieck, isForward, this.getStepStart(), updatedStepEnd, equationsMapper);
    }

    private class Corrector
    implements RealMatrixPreservingVisitor {
        private final double[] previous;
        private final double[] scaled;
        private final double[] before;
        private final double[] after;

        Corrector(double[] previous, double[] scaled, double[] state) {
            this.previous = previous;
            this.scaled = scaled;
            this.after = state;
            this.before = (double[])state.clone();
        }

        public void start(int rows, int columns, int startRow, int endRow, int startColumn, int endColumn) {
            Arrays.fill(this.after, 0.0);
        }

        public void visit(int row, int column, double value) {
            if ((row & 1) == 0) {
                int n = column;
                this.after[n] = this.after[n] - value;
            } else {
                int n = column;
                this.after[n] = this.after[n] + value;
            }
        }

        public double end() {
            StepsizeHelper helper = AdamsMoultonIntegrator.this.getStepSizeHelper();
            double error = 0.0;
            for (int i = 0; i < this.after.length; ++i) {
                int n = i;
                this.after[n] = this.after[n] + (this.previous[i] + this.scaled[i]);
                if (i >= helper.getMainSetDimension()) continue;
                double tol = helper.getTolerance(i, FastMath.max((double)FastMath.abs((double)this.previous[i]), (double)FastMath.abs((double)this.after[i])));
                double ratio = (this.after[i] - this.before[i]) / tol;
                error += ratio * ratio;
            }
            return FastMath.sqrt((double)(error / (double)helper.getMainSetDimension()));
        }
    }
}

