/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.events;

import java.util.Arrays;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.analysis.solvers.BracketedRealFieldUnivariateSolver;
import org.hipparchus.ode.FieldODEState;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.ode.events.AbstractFieldODEDetector;
import org.hipparchus.ode.events.Action;
import org.hipparchus.ode.events.FieldAdaptableInterval;
import org.hipparchus.ode.events.FieldODEEventDetector;
import org.hipparchus.ode.events.FieldODEEventHandler;
import org.hipparchus.ode.events.FilterType;
import org.hipparchus.ode.events.Transformer;
import org.hipparchus.util.MathArrays;

public class FieldEventSlopeFilter<T extends FieldODEEventDetector<E>, E extends CalculusFieldElement<E>>
extends AbstractFieldODEDetector<FieldEventSlopeFilter<T, E>, E> {
    private static final int HISTORY_SIZE = 100;
    private final T rawDetector;
    private final FilterType filter;
    private final Transformer[] transformers;
    private final E[] updates;
    private boolean forward;
    private E extremeT;

    public FieldEventSlopeFilter(Field<E> field, T rawDetector, FilterType filter) {
        this(field, rawDetector.getMaxCheckInterval(), rawDetector.getMaxIterationCount(), rawDetector.getSolver(), new LocalHandler(rawDetector.getHandler()), rawDetector, filter);
    }

    private FieldEventSlopeFilter(Field<E> field, FieldAdaptableInterval<E> maxCheck, int maxIter, BracketedRealFieldUnivariateSolver<E> solver, FieldODEEventHandler<E> handler, T rawDetector, FilterType filter) {
        super(maxCheck, maxIter, solver, handler);
        this.rawDetector = rawDetector;
        this.filter = filter;
        this.transformers = new Transformer[100];
        this.updates = (CalculusFieldElement[])MathArrays.buildArray(field, (int)100);
    }

    @Override
    protected FieldEventSlopeFilter<T, E> create(FieldAdaptableInterval<E> newMaxCheck, int newMaxIter, BracketedRealFieldUnivariateSolver<E> newSolver, FieldODEEventHandler<E> newHandler) {
        return new FieldEventSlopeFilter<T, E>(newSolver.getAbsoluteAccuracy().getField(), newMaxCheck, newMaxIter, newSolver, newHandler, this.rawDetector, this.filter);
    }

    public T getDetector() {
        return this.rawDetector;
    }

    @Override
    public void init(FieldODEStateAndDerivative<E> initialState, E finalTime) {
        super.init(initialState, finalTime);
        this.rawDetector.init(initialState, finalTime);
        this.forward = ((CalculusFieldElement)finalTime.subtract(initialState.getTime())).getReal() >= 0.0;
        this.extremeT = (CalculusFieldElement)((CalculusFieldElement)finalTime.getField().getZero()).newInstance(this.forward ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
        Arrays.fill((Object[])this.transformers, (Object)Transformer.UNINITIALIZED);
        Arrays.fill(this.updates, this.extremeT);
    }

    @Override
    public void reset(FieldODEStateAndDerivative<E> intermediateState, E finalTime) {
        super.reset(intermediateState, finalTime);
        this.rawDetector.reset(intermediateState, finalTime);
    }

    @Override
    public boolean isForward() {
        return this.forward;
    }

    @Override
    public E g(FieldODEStateAndDerivative<E> state) {
        E rawG = this.rawDetector.g(state);
        if (this.isForward()) {
            int last = this.transformers.length - 1;
            if (((CalculusFieldElement)this.extremeT.subtract(state.getTime())).getReal() < 0.0) {
                Transformer previous = this.transformers[last];
                Transformer next = this.filter.selectTransformer(previous, rawG.getReal(), this.forward);
                if (next != previous) {
                    System.arraycopy(this.updates, 1, this.updates, 0, last);
                    System.arraycopy(this.transformers, 1, this.transformers, 0, last);
                    this.updates[last] = this.extremeT;
                    this.transformers[last] = next;
                }
                this.extremeT = state.getTime();
                return next.transformed(rawG);
            }
            for (int i = last; i > 0; --i) {
                if (!(((CalculusFieldElement)this.updates[i].subtract(state.getTime())).getReal() <= 0.0)) continue;
                return this.transformers[i].transformed(rawG);
            }
            return this.transformers[0].transformed(rawG);
        }
        if (((CalculusFieldElement)state.getTime().subtract(this.extremeT)).getReal() < 0.0) {
            Transformer previous = this.transformers[0];
            Transformer next = this.filter.selectTransformer(previous, rawG.getReal(), this.forward);
            if (next != previous) {
                System.arraycopy(this.updates, 0, this.updates, 1, this.updates.length - 1);
                System.arraycopy(this.transformers, 0, this.transformers, 1, this.transformers.length - 1);
                this.updates[0] = this.extremeT;
                this.transformers[0] = next;
            }
            this.extremeT = state.getTime();
            return next.transformed(rawG);
        }
        for (int i = 0; i < this.updates.length - 1; ++i) {
            if (!(((CalculusFieldElement)state.getTime().subtract(this.updates[i])).getReal() <= 0.0)) continue;
            return this.transformers[i].transformed(rawG);
        }
        return this.transformers[this.updates.length - 1].transformed(rawG);
    }

    private static class LocalHandler<T extends FieldODEEventDetector<E>, E extends CalculusFieldElement<E>>
    implements FieldODEEventHandler<E> {
        private final FieldODEEventHandler<E> rawHandler;

        LocalHandler(FieldODEEventHandler<E> rawHandler) {
            this.rawHandler = rawHandler;
        }

        @Override
        public Action eventOccurred(FieldODEStateAndDerivative<E> state, FieldODEEventDetector<E> detector, boolean increasing) {
            FieldEventSlopeFilter esf = (FieldEventSlopeFilter)detector;
            return this.rawHandler.eventOccurred(state, esf, esf.filter.isTriggeredOnIncreasing());
        }

        @Override
        public FieldODEState<E> resetState(FieldODEEventDetector<E> detector, FieldODEStateAndDerivative<E> state) {
            FieldEventSlopeFilter esf = (FieldEventSlopeFilter)detector;
            return this.rawHandler.resetState(esf, state);
        }
    }
}

