/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode.events;

import org.hipparchus.analysis.UnivariateFunction;
import org.hipparchus.analysis.solvers.BracketedUnivariateSolver;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.ode.LocalizedODEFormats;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.events.Action;
import org.hipparchus.ode.events.EventOccurrence;
import org.hipparchus.ode.events.EventState;
import org.hipparchus.ode.events.ODEEventDetector;
import org.hipparchus.ode.events.ODEEventHandler;
import org.hipparchus.ode.sampling.ODEStateInterpolator;
import org.hipparchus.util.FastMath;

public class DetectorBasedEventState
implements EventState {
    private final ODEEventDetector detector;
    private final BracketedUnivariateSolver<UnivariateFunction> solver;
    private final ODEEventHandler handler;
    private double lastT;
    private double lastG;
    private double t0;
    private double g0;
    private boolean g0Positive;
    private boolean pendingEvent;
    private double pendingEventTime;
    private double stopTime;
    private double afterEvent;
    private double afterG;
    private double earliestTimeConsidered;
    private boolean forward;
    private boolean increasing;

    public DetectorBasedEventState(ODEEventDetector detector) {
        this.detector = detector;
        this.solver = detector.getSolver();
        this.handler = detector.getHandler();
        this.t0 = Double.NaN;
        this.g0 = Double.NaN;
        this.g0Positive = true;
        this.pendingEvent = false;
        this.pendingEventTime = Double.NaN;
        this.increasing = true;
        this.earliestTimeConsidered = Double.NaN;
        this.afterEvent = Double.NaN;
        this.afterG = Double.NaN;
    }

    public ODEEventDetector getEventDetector() {
        return this.detector;
    }

    @Override
    public void init(ODEStateAndDerivative s0, double t) {
        this.detector.init(s0, t);
        this.lastT = Double.NEGATIVE_INFINITY;
        this.lastG = Double.NaN;
    }

    private double g(ODEStateAndDerivative s) {
        if (s.getTime() != this.lastT) {
            this.lastG = this.detector.g(s);
            this.lastT = s.getTime();
        }
        return this.lastG;
    }

    public void reinitializeBegin(ODEStateInterpolator interpolator) throws MathIllegalStateException {
        this.forward = interpolator.isForward();
        ODEStateAndDerivative s0 = interpolator.getPreviousState();
        this.t0 = s0.getTime();
        this.g0 = this.g(s0);
        while (this.g0 == 0.0) {
            double tStart = this.t0 + (this.forward ? 0.5 : -0.5) * this.solver.getAbsoluteAccuracy();
            if (tStart == this.t0) {
                tStart = this.nextAfter(this.t0);
            }
            this.t0 = tStart;
            this.g0 = this.g(interpolator.getInterpolatedState(tStart));
        }
        this.increasing = this.g0Positive = this.g0 > 0.0;
    }

    @Override
    public boolean evaluateStep(ODEStateInterpolator interpolator) throws MathIllegalArgumentException, MathIllegalStateException {
        this.forward = interpolator.isForward();
        ODEStateAndDerivative s0 = interpolator.getPreviousState();
        ODEStateAndDerivative s1 = interpolator.getCurrentState();
        double t1 = s1.getTime();
        double dt = t1 - this.t0;
        if (FastMath.abs((double)dt) < this.solver.getAbsoluteAccuracy()) {
            this.pendingEvent = false;
            this.pendingEventTime = Double.NaN;
            return false;
        }
        double ta = this.t0;
        double ga = this.g0;
        ODEStateAndDerivative sb = this.nextCheck(s0, s1, interpolator);
        while (sb != null) {
            double tb = sb.getTime();
            double gb = this.g(sb);
            if (gb == 0.0 || this.g0Positive ^ gb > 0.0) {
                if (this.findRoot(interpolator, ta, ga, tb, gb)) {
                    return true;
                }
            } else {
                ta = tb;
                ga = gb;
            }
            sb = this.nextCheck(sb, s1, interpolator);
        }
        this.pendingEvent = false;
        this.pendingEventTime = Double.NaN;
        return false;
    }

    private ODEStateAndDerivative nextCheck(ODEStateAndDerivative done, ODEStateAndDerivative target, ODEStateInterpolator interpolator) {
        if (done == target) {
            return null;
        }
        double dt = target.getTime() - done.getTime();
        double maxCheck = this.detector.getMaxCheckInterval().currentInterval(done, dt >= 0.0);
        int n = FastMath.max((int)1, (int)((int)FastMath.ceil((double)(FastMath.abs((double)dt) / maxCheck))));
        return n == 1 ? target : interpolator.getInterpolatedState(done.getTime() + dt / (double)n);
    }

    private boolean findRoot(ODEStateInterpolator interpolator, double ta, double ga, double tb, double gb) {
        double newGa;
        this.check(ga == 0.0 || gb == 0.0 || ga > 0.0 && gb < 0.0 || ga < 0.0 && gb > 0.0);
        int maxIterationCount = this.detector.getMaxIterationCount();
        UnivariateFunction f = t -> this.g(interpolator.getInterpolatedState(t));
        double loopT = ta;
        double loopG = ga;
        double beforeRootT = Double.NaN;
        double beforeRootG = Double.NaN;
        double afterRootT = ta;
        double afterRootG = 0.0;
        if (ta == tb) {
            beforeRootT = ta;
            beforeRootG = ga;
            afterRootT = this.shiftedBy(beforeRootT, this.solver.getAbsoluteAccuracy());
            afterRootG = f.value(afterRootT);
        } else if (ga != 0.0 && gb == 0.0) {
            beforeRootT = tb;
            beforeRootG = gb;
            afterRootT = this.shiftedBy(beforeRootT, this.solver.getAbsoluteAccuracy());
            afterRootG = f.value(afterRootT);
        } else if (ga != 0.0 && ga > 0.0 != (newGa = f.value(ta)) > 0.0) {
            double nextT = this.minTime(this.shiftedBy(ta, this.solver.getAbsoluteAccuracy()), tb);
            double nextG = f.value(nextT);
            if (nextG > 0.0 == this.g0Positive) {
                loopT = nextT;
                loopG = nextG;
            } else {
                beforeRootT = ta;
                beforeRootG = newGa;
                afterRootT = nextT;
                afterRootG = nextG;
            }
        }
        while ((afterRootG == 0.0 || afterRootG > 0.0 == this.g0Positive) && this.strictlyAfter(afterRootT, tb)) {
            if (loopG == 0.0) {
                beforeRootT = loopT;
                beforeRootG = loopG;
                afterRootT = this.minTime(this.shiftedBy(beforeRootT, this.solver.getAbsoluteAccuracy()), tb);
                afterRootG = f.value(afterRootT);
            } else {
                if (this.forward) {
                    try {
                        BracketedUnivariateSolver.Interval interval = this.solver.solveInterval(maxIterationCount, f, loopT, tb);
                        beforeRootT = interval.getLeftAbscissa();
                        beforeRootG = interval.getLeftValue();
                        afterRootT = interval.getRightAbscissa();
                        afterRootG = interval.getRightValue();
                    }
                    catch (RuntimeException e) {
                        throw new MathIllegalStateException((Throwable)e, (Localizable)LocalizedODEFormats.FIND_ROOT, new Object[]{this.detector, loopT, loopG, tb, gb, this.lastT, this.lastG});
                    }
                }
                try {
                    BracketedUnivariateSolver.Interval interval = this.solver.solveInterval(maxIterationCount, f, tb, loopT);
                    beforeRootT = interval.getRightAbscissa();
                    beforeRootG = interval.getRightValue();
                    afterRootT = interval.getLeftAbscissa();
                    afterRootG = interval.getLeftValue();
                }
                catch (RuntimeException e) {
                    throw new MathIllegalStateException((Throwable)e, (Localizable)LocalizedODEFormats.FIND_ROOT, new Object[]{this.detector, tb, gb, loopT, loopG, this.lastT, this.lastG});
                }
            }
            if (beforeRootT == afterRootT) {
                afterRootT = this.nextAfter(afterRootT);
                afterRootG = f.value(afterRootT);
            }
            this.check(this.forward && afterRootT > beforeRootT || !this.forward && afterRootT < beforeRootT);
            loopT = afterRootT;
            loopG = afterRootG;
        }
        if (afterRootG == 0.0 || afterRootG > 0.0 == this.g0Positive) {
            return false;
        }
        this.check(!Double.isNaN(beforeRootT) && !Double.isNaN(beforeRootG));
        this.increasing = !this.g0Positive;
        this.pendingEventTime = beforeRootT;
        this.stopTime = beforeRootG == 0.0 ? beforeRootT : afterRootT;
        this.pendingEvent = true;
        this.afterEvent = afterRootT;
        this.afterG = afterRootG;
        this.check(this.afterG > 0.0 == this.increasing);
        this.check(this.increasing == gb >= ga);
        return true;
    }

    private double nextAfter(double t) {
        double dir = this.forward ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        return FastMath.nextAfter((double)t, (double)dir);
    }

    @Override
    public double getEventTime() {
        return this.pendingEvent ? this.pendingEventTime : (this.forward ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY);
    }

    public boolean tryAdvance(ODEStateAndDerivative state, ODEStateInterpolator interpolator) {
        boolean meFirst;
        double t = state.getTime();
        this.check(!this.pendingEvent || !this.strictlyAfter(this.pendingEventTime, t));
        if (this.strictlyAfter(t, this.earliestTimeConsidered)) {
            meFirst = false;
        } else {
            boolean positive;
            double g = this.g(state);
            boolean bl = positive = g > 0.0;
            if (positive == this.g0Positive) {
                this.g0 = g;
                meFirst = false;
            } else {
                double oldPendingEventTime = this.pendingEventTime;
                boolean foundRoot = this.findRoot(interpolator, this.t0, this.g0, t, g);
                boolean bl2 = meFirst = foundRoot && (Double.isNaN(oldPendingEventTime) || oldPendingEventTime != this.pendingEventTime);
            }
        }
        if (!meFirst) {
            this.t0 = t;
        }
        return meFirst;
    }

    @Override
    public EventOccurrence doEvent(ODEStateAndDerivative state) {
        this.check(this.pendingEvent);
        this.check(state.getTime() == this.pendingEventTime);
        Action action = this.handler.eventOccurred(state, this.detector, this.increasing == this.forward);
        ODEState newState = action == Action.RESET_STATE ? this.handler.resetState(this.detector, state) : state;
        this.pendingEvent = false;
        this.pendingEventTime = Double.NaN;
        this.earliestTimeConsidered = this.afterEvent;
        this.t0 = this.afterEvent;
        this.g0 = this.afterG;
        this.g0Positive = this.increasing;
        this.check(this.g0 == 0.0 || this.g0Positive == this.g0 > 0.0);
        return new EventOccurrence(action, newState, this.stopTime);
    }

    private double shiftedBy(double t, double delta) {
        if (this.forward) {
            double ret = t + delta;
            if (ret - t > delta) {
                return FastMath.nextDown((double)ret);
            }
            return ret;
        }
        double ret = t - delta;
        if (t - ret > delta) {
            return FastMath.nextUp((double)ret);
        }
        return ret;
    }

    private double minTime(double a, double b) {
        return this.forward ? FastMath.min((double)a, (double)b) : FastMath.max((double)a, (double)b);
    }

    private boolean strictlyAfter(double t1, double t2) {
        return this.forward ? t1 < t2 : t2 < t1;
    }

    private void check(boolean condition) throws MathRuntimeException {
        if (!condition) {
            throw MathRuntimeException.createInternalError();
        }
    }
}

