/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import java.io.Serializable;

public class ODEState
implements Serializable {
    private static final long serialVersionUID = 20160408L;
    private final double time;
    private final double[] primaryState;
    private final double[][] secondaryState;
    private final int completeDimension;

    public ODEState(double time, double[] primaryState) {
        this(time, primaryState, null);
    }

    public ODEState(double time, double[] primaryState, double[][] secondaryState) {
        this.time = time;
        this.primaryState = (double[])primaryState.clone();
        this.secondaryState = this.copy(secondaryState);
        int dimension = primaryState.length;
        if (secondaryState != null) {
            for (double[] secondary : secondaryState) {
                dimension += secondary.length;
            }
        }
        this.completeDimension = dimension;
    }

    protected double[][] copy(double[][] original) {
        if (original == null) {
            return null;
        }
        double[][] copied = new double[original.length][];
        for (int i = 0; i < original.length; ++i) {
            copied[i] = (double[])original[i].clone();
        }
        return copied;
    }

    public double getTime() {
        return this.time;
    }

    public int getPrimaryStateDimension() {
        return this.primaryState.length;
    }

    public double[] getPrimaryState() {
        return (double[])this.primaryState.clone();
    }

    public int getNumberOfSecondaryStates() {
        return this.secondaryState == null ? 0 : this.secondaryState.length;
    }

    public int getSecondaryStateDimension(int index) {
        return index == 0 ? this.primaryState.length : this.secondaryState[index - 1].length;
    }

    public double[] getSecondaryState(int index) {
        return index == 0 ? (double[])this.primaryState.clone() : (double[])this.secondaryState[index - 1].clone();
    }

    public int getCompleteStateDimension() {
        return this.completeDimension;
    }

    public double[] getCompleteState() {
        double[] completeState = new double[this.getCompleteStateDimension()];
        System.arraycopy(this.primaryState, 0, completeState, 0, this.primaryState.length);
        int offset = this.primaryState.length;
        if (this.secondaryState != null) {
            for (double[] doubles : this.secondaryState) {
                System.arraycopy(doubles, 0, completeState, offset, doubles.length);
                offset += doubles.length;
            }
        }
        return completeState;
    }
}

