/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import java.util.List;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathIllegalStateException;
import org.hipparchus.ode.ExpandableODE;
import org.hipparchus.ode.ODEState;
import org.hipparchus.ode.ODEStateAndDerivative;
import org.hipparchus.ode.OrdinaryDifferentialEquation;
import org.hipparchus.ode.events.ODEEventDetector;
import org.hipparchus.ode.events.ODEStepEndHandler;
import org.hipparchus.ode.sampling.ODEStepHandler;

public interface ODEIntegrator {
    public String getName();

    public void addStepHandler(ODEStepHandler var1);

    public List<ODEStepHandler> getStepHandlers();

    public void clearStepHandlers();

    public void addEventDetector(ODEEventDetector var1);

    public List<ODEEventDetector> getEventDetectors();

    public void clearEventDetectors();

    public void addStepEndHandler(ODEStepEndHandler var1);

    public List<ODEStepEndHandler> getStepEndHandlers();

    public void clearStepEndHandlers();

    public ODEStateAndDerivative getStepStart();

    public double getCurrentSignedStepsize();

    public void setMaxEvaluations(int var1);

    public int getMaxEvaluations();

    public int getEvaluations();

    public ODEStateAndDerivative integrate(ExpandableODE var1, ODEState var2, double var3) throws MathIllegalArgumentException, MathIllegalStateException;

    default public ODEStateAndDerivative integrate(OrdinaryDifferentialEquation equations, ODEState initialState, double finalTime) throws MathIllegalArgumentException, MathIllegalStateException {
        return this.integrate(new ExpandableODE(equations), initialState, finalTime);
    }
}

