/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.ode;

import java.io.Serializable;
import org.hipparchus.CalculusFieldElement;
import org.hipparchus.Field;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.ode.FieldODEStateAndDerivative;
import org.hipparchus.util.MathArrays;
import org.hipparchus.util.MathUtils;

public class FieldEquationsMapper<T extends CalculusFieldElement<T>>
implements Serializable {
    private static final long serialVersionUID = 20151114L;
    private final int[] start;

    FieldEquationsMapper(FieldEquationsMapper<T> mapper, int dimension) {
        int index = mapper == null ? 0 : mapper.getNumberOfEquations();
        this.start = new int[index + 2];
        if (mapper == null) {
            this.start[0] = 0;
        } else {
            System.arraycopy(mapper.start, 0, this.start, 0, index + 1);
        }
        this.start[index + 1] = this.start[index] + dimension;
    }

    public int getNumberOfEquations() {
        return this.start.length - 1;
    }

    public int getTotalDimension() {
        return this.start[this.start.length - 1];
    }

    public FieldODEStateAndDerivative<T> mapStateAndDerivative(T t, T[] y, T[] yDot) throws MathIllegalArgumentException {
        if (y.length != this.getTotalDimension()) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{y.length, this.getTotalDimension()});
        }
        if (yDot.length != this.getTotalDimension()) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{yDot.length, this.getTotalDimension()});
        }
        int n = this.getNumberOfEquations();
        CalculusFieldElement[] state = this.extractEquationData(0, (CalculusFieldElement[])y);
        CalculusFieldElement[] derivative = this.extractEquationData(0, (CalculusFieldElement[])yDot);
        if (n < 2) {
            return new FieldODEStateAndDerivative(t, state, derivative);
        }
        CalculusFieldElement[][] secondaryState = (CalculusFieldElement[][])MathArrays.buildArray((Field)t.getField(), (int)(n - 1), (int)-1);
        CalculusFieldElement[][] secondaryDerivative = (CalculusFieldElement[][])MathArrays.buildArray((Field)t.getField(), (int)(n - 1), (int)-1);
        for (int index = 1; index < this.getNumberOfEquations(); ++index) {
            secondaryState[index - 1] = this.extractEquationData(index, (CalculusFieldElement[])y);
            secondaryDerivative[index - 1] = this.extractEquationData(index, (CalculusFieldElement[])yDot);
        }
        return new FieldODEStateAndDerivative(t, state, derivative, secondaryState, secondaryDerivative);
    }

    public T[] extractEquationData(int index, T[] complete) throws MathIllegalArgumentException {
        this.checkIndex(index);
        int begin = this.start[index];
        int end = this.start[index + 1];
        if (complete.length < end) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{complete.length, end});
        }
        int dimension = end - begin;
        CalculusFieldElement[] equationData = (CalculusFieldElement[])MathArrays.buildArray((Field)complete[0].getField(), (int)dimension);
        System.arraycopy(complete, begin, equationData, 0, dimension);
        return equationData;
    }

    public void insertEquationData(int index, T[] equationData, T[] complete) throws MathIllegalArgumentException {
        this.checkIndex(index);
        int begin = this.start[index];
        int end = this.start[index + 1];
        int dimension = end - begin;
        if (complete.length < end) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{complete.length, end});
        }
        if (equationData.length != dimension) {
            throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.DIMENSIONS_MISMATCH, new Object[]{equationData.length, dimension});
        }
        System.arraycopy(equationData, 0, complete, begin, dimension);
    }

    private void checkIndex(int index) throws MathIllegalArgumentException {
        MathUtils.checkRangeInclusive((long)index, (long)0L, (long)(this.start.length - 2));
    }
}

