/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.spherical.twod;

import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.partitioning.BSPTree;
import org.hipparchus.geometry.spherical.twod.Circle;
import org.hipparchus.geometry.spherical.twod.Edge;
import org.hipparchus.geometry.spherical.twod.S2Point;
import org.hipparchus.geometry.spherical.twod.Sphere2D;
import org.hipparchus.geometry.spherical.twod.SubCircle;
import org.hipparchus.geometry.spherical.twod.Vertex;

class EdgeWithNodeInfo
extends Edge {
    private final BSPTree<Sphere2D, S2Point, Circle, SubCircle> node;
    private final BSPTree<Sphere2D, S2Point, Circle, SubCircle> startNode;
    private final BSPTree<Sphere2D, S2Point, Circle, SubCircle> endNode;
    private boolean processed;

    EdgeWithNodeInfo(Vertex start, Vertex end, double length, Circle circle, BSPTree<Sphere2D, S2Point, Circle, SubCircle> node, BSPTree<Sphere2D, S2Point, Circle, SubCircle> startNode, BSPTree<Sphere2D, S2Point, Circle, SubCircle> endNode) {
        super(start, end, length, circle);
        this.node = node;
        this.startNode = startNode;
        this.endNode = endNode;
        this.processed = false;
    }

    public static boolean areNaturalFollowers(EdgeWithNodeInfo previous, EdgeWithNodeInfo next) {
        return next.getStart().getIncoming() == null && previous.endNode == next.node && previous.node == next.startNode && Vector3D.dotProduct(previous.getEnd().getLocation().getVector(), next.getStart().getLocation().getVector()) > 0.0;
    }

    public static boolean resultFromASplit(EdgeWithNodeInfo previous, EdgeWithNodeInfo next) {
        return next.getStart().getIncoming() == null && previous.node.getCut().getHyperplane() == next.node.getCut().getHyperplane() && previous.endNode == next.startNode && Vector3D.dotProduct(previous.getEnd().getLocation().getVector(), next.getStart().getLocation().getVector()) > 0.0;
    }

    public void setProcessed(boolean processed) {
        this.processed = processed;
    }

    public boolean isProcessed() {
        return this.processed;
    }
}

