/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.spherical.twod;

import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.partitioning.Embedding;
import org.hipparchus.geometry.partitioning.Hyperplane;
import org.hipparchus.geometry.partitioning.RegionFactory;
import org.hipparchus.geometry.partitioning.Transform;
import org.hipparchus.geometry.spherical.oned.Arc;
import org.hipparchus.geometry.spherical.oned.ArcsSet;
import org.hipparchus.geometry.spherical.oned.LimitAngle;
import org.hipparchus.geometry.spherical.oned.S1Point;
import org.hipparchus.geometry.spherical.oned.Sphere1D;
import org.hipparchus.geometry.spherical.oned.SubLimitAngle;
import org.hipparchus.geometry.spherical.twod.S2Point;
import org.hipparchus.geometry.spherical.twod.Sphere2D;
import org.hipparchus.geometry.spherical.twod.SphericalPolygonsSet;
import org.hipparchus.geometry.spherical.twod.SubCircle;
import org.hipparchus.util.FastMath;
import org.hipparchus.util.SinCos;

public class Circle
implements Hyperplane<Sphere2D, S2Point, Circle, SubCircle>,
Embedding<Sphere2D, S2Point, Sphere1D, S1Point> {
    private Vector3D pole;
    private Vector3D x;
    private Vector3D y;
    private final double tolerance;

    public Circle(Vector3D pole, double tolerance) throws MathIllegalArgumentException {
        Sphere2D.checkTolerance(tolerance);
        this.reset(pole);
        this.tolerance = tolerance;
    }

    public Circle(S2Point first, S2Point second, double tolerance) throws MathIllegalArgumentException {
        Sphere2D.checkTolerance(tolerance);
        this.reset(first.getVector().crossProduct(second.getVector()));
        this.tolerance = tolerance;
    }

    private Circle(Vector3D pole, Vector3D x, Vector3D y, double tolerance) throws MathIllegalArgumentException {
        Sphere2D.checkTolerance(tolerance);
        this.pole = pole;
        this.x = x;
        this.y = y;
        this.tolerance = tolerance;
    }

    public Circle(Circle circle) {
        this(circle.pole, circle.x, circle.y, circle.tolerance);
    }

    @Override
    public Circle copySelf() {
        return new Circle(this);
    }

    public void reset(Vector3D newPole) {
        this.pole = (Vector3D)newPole.normalize();
        this.x = newPole.orthogonal();
        this.y = (Vector3D)Vector3D.crossProduct(newPole, this.x).normalize();
    }

    public void revertSelf() {
        this.y = this.y.negate();
        this.pole = this.pole.negate();
    }

    public Circle getReverse() {
        return new Circle(this.pole.negate(), this.x, this.y.negate(), this.tolerance);
    }

    @Override
    public S2Point project(S2Point point) {
        return this.toSpace(this.toSubSpace(point));
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    @Override
    public S1Point toSubSpace(S2Point point) {
        return new S1Point(this.getPhase(point.getVector()));
    }

    public double getPhase(Vector3D direction) {
        return Math.PI + FastMath.atan2((double)(-direction.dotProduct(this.y)), (double)(-direction.dotProduct(this.x)));
    }

    @Override
    public S2Point toSpace(S1Point point) {
        return new S2Point(this.getPointAt(point.getAlpha()));
    }

    public Vector3D getPointAt(double alpha) {
        SinCos sc = FastMath.sinCos((double)alpha);
        return new Vector3D(sc.cos(), this.x, sc.sin(), this.y);
    }

    public Vector3D getXAxis() {
        return this.x;
    }

    public Vector3D getYAxis() {
        return this.y;
    }

    public Vector3D getPole() {
        return this.pole;
    }

    public Arc getInsideArc(Circle other) {
        double alpha = this.getPhase(other.pole);
        return new Arc(alpha - 1.5707963267948966, alpha + 1.5707963267948966, this.tolerance);
    }

    @Override
    public SubCircle wholeHyperplane() {
        return new SubCircle(this, new ArcsSet(this.tolerance));
    }

    @Override
    public SubCircle emptyHyperplane() {
        RegionFactory<Sphere1D, S1Point, LimitAngle, SubLimitAngle> factory = new RegionFactory<Sphere1D, S1Point, LimitAngle, SubLimitAngle>();
        return new SubCircle(this, factory.getComplement(new ArcsSet(this.tolerance)));
    }

    public SphericalPolygonsSet wholeSpace() {
        return new SphericalPolygonsSet(this.tolerance);
    }

    @Override
    public double getOffset(S2Point point) {
        return this.getOffset(point.getVector());
    }

    @Override
    public double getOffset(Vector3D direction) {
        return Vector3D.angle(this.pole, direction) - 1.5707963267948966;
    }

    @Override
    public S2Point moveToOffset(S2Point point, double offset) {
        SinCos scOld = FastMath.sinCos((double)this.getOffset(point));
        SinCos scNew = FastMath.sinCos((double)offset);
        double ratio = scNew.cos() / scOld.cos();
        return new S2Point(new Vector3D(ratio * scOld.sin() - scNew.sin(), this.pole, ratio, point.getVector()));
    }

    @Override
    public S2Point arbitraryPoint() {
        return new S2Point(this.pole.orthogonal());
    }

    @Override
    public boolean sameOrientationAs(Circle other) {
        return Vector3D.dotProduct(this.pole, other.pole) >= 0.0;
    }

    public Arc getArc(S2Point a, S2Point b) {
        double phaseA = this.getPhase(a.getVector());
        double phaseB = this.getPhase(b.getVector());
        if (phaseB < phaseA) {
            phaseB += Math.PI * 2;
        }
        return new Arc(phaseA, phaseB, this.tolerance);
    }

    public static Transform<Sphere2D, S2Point, Circle, SubCircle, Sphere1D, S1Point, LimitAngle, SubLimitAngle> getTransform(Rotation rotation) {
        return new CircleTransform(rotation);
    }

    private static class CircleTransform
    implements Transform<Sphere2D, S2Point, Circle, SubCircle, Sphere1D, S1Point, LimitAngle, SubLimitAngle> {
        private final Rotation rotation;

        CircleTransform(Rotation rotation) {
            this.rotation = rotation;
        }

        @Override
        public S2Point apply(S2Point point) {
            return new S2Point(this.rotation.applyTo(point.getVector()));
        }

        @Override
        public Circle apply(Circle circle) {
            return new Circle(this.rotation.applyTo(circle.pole), this.rotation.applyTo(circle.x), this.rotation.applyTo(circle.y), circle.tolerance);
        }

        @Override
        public SubLimitAngle apply(SubLimitAngle sub, Circle original, Circle transformed) {
            return sub;
        }
    }
}

