/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.spherical.oned;

import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.geometry.partitioning.Hyperplane;
import org.hipparchus.geometry.spherical.oned.ArcsSet;
import org.hipparchus.geometry.spherical.oned.S1Point;
import org.hipparchus.geometry.spherical.oned.Sphere1D;
import org.hipparchus.geometry.spherical.oned.SubLimitAngle;

public class LimitAngle
implements Hyperplane<Sphere1D, S1Point, LimitAngle, SubLimitAngle> {
    private final S1Point location;
    private final boolean direct;
    private final double tolerance;

    public LimitAngle(S1Point location, boolean direct, double tolerance) throws MathIllegalArgumentException {
        Sphere1D.checkTolerance(tolerance);
        this.location = location;
        this.direct = direct;
        this.tolerance = tolerance;
    }

    @Override
    public LimitAngle copySelf() {
        return this;
    }

    @Override
    public double getOffset(S1Point point) {
        double delta = point.getAlpha() - this.location.getAlpha();
        return this.direct ? delta : -delta;
    }

    @Override
    public S1Point moveToOffset(S1Point point, double offset) {
        return new S1Point(this.location.getAlpha() + (this.direct ? offset : -offset));
    }

    @Override
    public S1Point arbitraryPoint() {
        return this.location;
    }

    public boolean isDirect() {
        return this.direct;
    }

    public LimitAngle getReverse() {
        return new LimitAngle(this.location, !this.direct, this.tolerance);
    }

    @Override
    public SubLimitAngle wholeHyperplane() {
        return new SubLimitAngle(this, null);
    }

    @Override
    public SubLimitAngle emptyHyperplane() {
        return new SubLimitAngle(this, null);
    }

    public ArcsSet wholeSpace() {
        return new ArcsSet(this.tolerance);
    }

    @Override
    public boolean sameOrientationAs(LimitAngle other) {
        return this.direct == other.direct;
    }

    public S1Point getLocation() {
        return this.location;
    }

    @Override
    public S1Point project(S1Point point) {
        return this.location;
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }
}

