/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.partitioning;

import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.Space;
import org.hipparchus.geometry.partitioning.BSPTree;
import org.hipparchus.geometry.partitioning.BSPTreeVisitor;
import org.hipparchus.geometry.partitioning.BoundaryAttribute;
import org.hipparchus.geometry.partitioning.Hyperplane;
import org.hipparchus.geometry.partitioning.SubHyperplane;

class BoundarySizeVisitor<S extends Space, P extends Point<S, P>, H extends Hyperplane<S, P, H, I>, I extends SubHyperplane<S, P, H, I>>
implements BSPTreeVisitor<S, P, H, I> {
    private double boundarySize = 0.0;

    BoundarySizeVisitor() {
    }

    @Override
    public BSPTreeVisitor.Order visitOrder(BSPTree<S, P, H, I> node) {
        return BSPTreeVisitor.Order.MINUS_SUB_PLUS;
    }

    @Override
    public void visitInternalNode(BSPTree<S, P, H, I> node) {
        BoundaryAttribute attribute = (BoundaryAttribute)node.getAttribute();
        if (attribute.getPlusOutside() != null) {
            this.boundarySize += attribute.getPlusOutside().getSize();
        }
        if (attribute.getPlusInside() != null) {
            this.boundarySize += attribute.getPlusInside().getSize();
        }
    }

    @Override
    public void visitLeafNode(BSPTree<S, P, H, I> node) {
    }

    public double getSize() {
        return this.boundarySize;
    }
}

