/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.partitioning;

import java.util.HashMap;
import java.util.Map;
import org.hipparchus.geometry.Point;
import org.hipparchus.geometry.Space;
import org.hipparchus.geometry.partitioning.BSPTree;
import org.hipparchus.geometry.partitioning.BoundaryAttribute;
import org.hipparchus.geometry.partitioning.Hyperplane;
import org.hipparchus.geometry.partitioning.NodesSet;
import org.hipparchus.geometry.partitioning.Region;
import org.hipparchus.geometry.partitioning.RegionFactory;
import org.hipparchus.geometry.partitioning.SubHyperplane;
import org.hipparchus.geometry.partitioning.Transform;

public abstract class AbstractSubHyperplane<S extends Space, P extends Point<S, P>, H extends Hyperplane<S, P, H, I>, I extends SubHyperplane<S, P, H, I>, T extends Space, Q extends Point<T, Q>, F extends Hyperplane<T, Q, F, J>, J extends SubHyperplane<T, Q, F, J>>
implements SubHyperplane<S, P, H, I> {
    private final H hyperplane;
    private final Region<T, Q, F, J> remainingRegion;

    protected AbstractSubHyperplane(H hyperplane, Region<T, Q, F, J> remainingRegion) {
        this.hyperplane = hyperplane;
        this.remainingRegion = remainingRegion;
    }

    protected abstract I buildNew(H var1, Region<T, Q, F, J> var2);

    @Override
    public I copySelf() {
        return this.buildNew(this.hyperplane.copySelf(), this.remainingRegion);
    }

    @Override
    public H getHyperplane() {
        return this.hyperplane;
    }

    public Region<T, Q, F, J> getRemainingRegion() {
        return this.remainingRegion;
    }

    @Override
    public double getSize() {
        return this.remainingRegion.getSize();
    }

    @Override
    public I reunite(I other) {
        AbstractSubHyperplane o = (AbstractSubHyperplane)other;
        return this.buildNew(this.hyperplane, new RegionFactory<T, Q, F, J>().union(this.remainingRegion, o.remainingRegion));
    }

    public I applyTransform(Transform<S, P, H, I, T, Q, F, J> transform) {
        H tHyperplane = transform.apply(this.hyperplane);
        HashMap<BSPTree<T, Q, F, J>, BSPTree<T, Q, F, J>> map = new HashMap<BSPTree<T, Q, F, J>, BSPTree<T, Q, F, J>>();
        BSPTree<T, Q, F, J> tTree = this.recurseTransform(this.remainingRegion.getTree(false), tHyperplane, transform, map);
        for (Map.Entry entry : map.entrySet()) {
            BoundaryAttribute original;
            if (((BSPTree)entry.getKey()).getCut() == null || (original = (BoundaryAttribute)((BSPTree)entry.getKey()).getAttribute()) == null) continue;
            BoundaryAttribute transformed = (BoundaryAttribute)((BSPTree)entry.getValue()).getAttribute();
            for (BSPTree splitter : original.getSplitters()) {
                transformed.getSplitters().add((BSPTree)map.get(splitter));
            }
        }
        return this.buildNew(tHyperplane, this.remainingRegion.buildNew(tTree));
    }

    private BSPTree<T, Q, F, J> recurseTransform(BSPTree<T, Q, F, J> node, H transformed, Transform<S, P, H, I, T, Q, F, J> transform, Map<BSPTree<T, Q, F, J>, BSPTree<T, Q, F, J>> map) {
        BSPTree<Object, Object, Object, Object> transformedNode;
        if (node.getCut() == null) {
            transformedNode = new BSPTree(node.getAttribute());
        } else {
            BoundaryAttribute attribute = (BoundaryAttribute)node.getAttribute();
            if (attribute != null) {
                Object tPO = attribute.getPlusOutside() == null ? null : (Object)transform.apply(attribute.getPlusOutside(), this.hyperplane, transformed);
                Object tPI = attribute.getPlusInside() == null ? null : (Object)transform.apply(attribute.getPlusInside(), this.hyperplane, transformed);
                attribute = new BoundaryAttribute(tPO, tPI, new NodesSet());
            }
            transformedNode = new BSPTree<T, Q, F, J>(transform.apply(node.getCut(), this.hyperplane, transformed), this.recurseTransform(node.getPlus(), transformed, transform, map), this.recurseTransform(node.getMinus(), transformed, transform, map), attribute);
        }
        map.put(node, transformedNode);
        return transformedNode;
    }

    @Override
    public abstract SubHyperplane.SplitSubHyperplane<S, P, H, I> split(H var1);

    @Override
    public boolean isEmpty() {
        return this.remainingRegion.isEmpty();
    }
}

