/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.threed;

import org.hipparchus.geometry.euclidean.oned.Vector1D;
import org.hipparchus.geometry.euclidean.threed.Euclidean3D;
import org.hipparchus.geometry.euclidean.threed.Line;
import org.hipparchus.geometry.euclidean.threed.Plane;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.euclidean.twod.Euclidean2D;
import org.hipparchus.geometry.euclidean.twod.PolygonsSet;
import org.hipparchus.geometry.euclidean.twod.SubLine;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.geometry.partitioning.AbstractSubHyperplane;
import org.hipparchus.geometry.partitioning.BSPTree;
import org.hipparchus.geometry.partitioning.Region;
import org.hipparchus.geometry.partitioning.SubHyperplane;

public class SubPlane
extends AbstractSubHyperplane<Euclidean3D, Vector3D, Plane, SubPlane, Euclidean2D, Vector2D, org.hipparchus.geometry.euclidean.twod.Line, SubLine> {
    public SubPlane(Plane hyperplane, Region<Euclidean2D, Vector2D, org.hipparchus.geometry.euclidean.twod.Line, SubLine> remainingRegion) {
        super(hyperplane, remainingRegion);
    }

    @Override
    protected SubPlane buildNew(Plane hyperplane, Region<Euclidean2D, Vector2D, org.hipparchus.geometry.euclidean.twod.Line, SubLine> remainingRegion) {
        return new SubPlane(hyperplane, remainingRegion);
    }

    @Override
    public Vector3D getInteriorPoint() {
        return this.isEmpty() ? null : ((Plane)this.getHyperplane()).toSpace((Vector2D)this.getRemainingRegion().getInteriorPoint());
    }

    @Override
    public SubHyperplane.SplitSubHyperplane<Euclidean3D, Vector3D, Plane, SubPlane> split(Plane hyperplane) {
        Line inter = hyperplane.intersection((Plane)this.getHyperplane());
        double tolerance = ((Plane)this.getHyperplane()).getTolerance();
        if (inter == null) {
            double global = hyperplane.getOffset((Plane)this.getHyperplane());
            if (global < -tolerance) {
                return new SubHyperplane.SplitSubHyperplane<Euclidean3D, Vector3D, Plane, SubPlane>(null, this);
            }
            if (global > tolerance) {
                return new SubHyperplane.SplitSubHyperplane(this, null);
            }
            return new SubHyperplane.SplitSubHyperplane(null, null);
        }
        Vector2D p = ((Plane)this.getHyperplane()).toSubSpace(inter.toSpace(Vector1D.ZERO));
        Vector2D q = ((Plane)this.getHyperplane()).toSubSpace(inter.toSpace(Vector1D.ONE));
        Vector3D crossP = Vector3D.crossProduct(inter.getDirection(), ((Plane)this.getHyperplane()).getNormal());
        if (crossP.dotProduct(hyperplane.getNormal()) < 0.0) {
            Vector2D tmp = p;
            p = q;
            q = tmp;
        }
        SubLine l2DMinus = new org.hipparchus.geometry.euclidean.twod.Line(p, q, tolerance).wholeHyperplane();
        SubLine l2DPlus = new org.hipparchus.geometry.euclidean.twod.Line(q, p, tolerance).wholeHyperplane();
        BSPTree splitTree = this.getRemainingRegion().getTree(false).split(l2DMinus);
        BSPTree<Euclidean2D, Vector2D, org.hipparchus.geometry.euclidean.twod.Line, SubLine> plusTree = this.getRemainingRegion().isEmpty(splitTree.getPlus()) ? new BSPTree<Euclidean2D, Vector2D, org.hipparchus.geometry.euclidean.twod.Line, SubLine>(Boolean.FALSE) : new BSPTree(l2DPlus, new BSPTree(Boolean.FALSE), splitTree.getPlus(), null);
        BSPTree<Euclidean2D, Vector2D, org.hipparchus.geometry.euclidean.twod.Line, SubLine> minusTree = this.getRemainingRegion().isEmpty(splitTree.getMinus()) ? new BSPTree<Euclidean2D, Vector2D, org.hipparchus.geometry.euclidean.twod.Line, SubLine>(Boolean.FALSE) : new BSPTree(l2DMinus, new BSPTree(Boolean.FALSE), splitTree.getMinus(), null);
        return new SubHyperplane.SplitSubHyperplane<Euclidean3D, Vector3D, Plane, SubPlane>(new SubPlane(((Plane)this.getHyperplane()).copySelf(), new PolygonsSet(plusTree, tolerance)), new SubPlane(((Plane)this.getHyperplane()).copySelf(), new PolygonsSet(minusTree, tolerance)));
    }
}

