/*
 * Decompiled with CFR 0.152.
 */
package org.hipparchus.geometry.euclidean.threed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hipparchus.exception.Localizable;
import org.hipparchus.exception.LocalizedCoreFormats;
import org.hipparchus.exception.MathIllegalArgumentException;
import org.hipparchus.exception.MathRuntimeException;
import org.hipparchus.geometry.LocalizedGeometryFormats;
import org.hipparchus.geometry.euclidean.oned.Euclidean1D;
import org.hipparchus.geometry.euclidean.oned.OrientedPoint;
import org.hipparchus.geometry.euclidean.oned.SubOrientedPoint;
import org.hipparchus.geometry.euclidean.oned.Vector1D;
import org.hipparchus.geometry.euclidean.threed.Euclidean3D;
import org.hipparchus.geometry.euclidean.threed.Line;
import org.hipparchus.geometry.euclidean.threed.Plane;
import org.hipparchus.geometry.euclidean.threed.Rotation;
import org.hipparchus.geometry.euclidean.threed.SubPlane;
import org.hipparchus.geometry.euclidean.threed.Vector3D;
import org.hipparchus.geometry.euclidean.twod.Euclidean2D;
import org.hipparchus.geometry.euclidean.twod.PolygonsSet;
import org.hipparchus.geometry.euclidean.twod.SubLine;
import org.hipparchus.geometry.euclidean.twod.Vector2D;
import org.hipparchus.geometry.partitioning.AbstractRegion;
import org.hipparchus.geometry.partitioning.BSPTree;
import org.hipparchus.geometry.partitioning.BSPTreeVisitor;
import org.hipparchus.geometry.partitioning.BoundaryAttribute;
import org.hipparchus.geometry.partitioning.InteriorPointFinder;
import org.hipparchus.geometry.partitioning.Region;
import org.hipparchus.geometry.partitioning.RegionFactory;
import org.hipparchus.geometry.partitioning.SubHyperplane;
import org.hipparchus.geometry.partitioning.Transform;
import org.hipparchus.util.FastMath;

public class PolyhedronsSet
extends AbstractRegion<Euclidean3D, Vector3D, Plane, SubPlane, Euclidean2D, Vector2D, org.hipparchus.geometry.euclidean.twod.Line, SubLine> {
    public PolyhedronsSet(double tolerance) {
        super(tolerance);
    }

    public PolyhedronsSet(BSPTree<Euclidean3D, Vector3D, Plane, SubPlane> tree, double tolerance) {
        super(tree, tolerance);
    }

    public PolyhedronsSet(Collection<SubPlane> boundary, double tolerance) {
        super(boundary, tolerance);
    }

    public PolyhedronsSet(List<Vector3D> vertices, List<int[]> facets, double tolerance) {
        super(PolyhedronsSet.buildBoundary(vertices, facets, tolerance), tolerance);
    }

    public PolyhedronsSet(BRep brep, double tolerance) {
        super(PolyhedronsSet.buildBoundary(brep.getVertices(), brep.getFacets(), tolerance), tolerance);
    }

    public PolyhedronsSet(double xMin, double xMax, double yMin, double yMax, double zMin, double zMax, double tolerance) {
        super(PolyhedronsSet.buildBoundary(xMin, xMax, yMin, yMax, zMin, zMax, tolerance), tolerance);
    }

    private static BSPTree<Euclidean3D, Vector3D, Plane, SubPlane> buildBoundary(double xMin, double xMax, double yMin, double yMax, double zMin, double zMax, double tolerance) {
        if (xMin >= xMax - tolerance || yMin >= yMax - tolerance || zMin >= zMax - tolerance) {
            return new BSPTree<Euclidean3D, Vector3D, Plane, SubPlane>(Boolean.FALSE);
        }
        Plane pxMin = new Plane(new Vector3D(xMin, 0.0, 0.0), Vector3D.MINUS_I, tolerance);
        Plane pxMax = new Plane(new Vector3D(xMax, 0.0, 0.0), Vector3D.PLUS_I, tolerance);
        Plane pyMin = new Plane(new Vector3D(0.0, yMin, 0.0), Vector3D.MINUS_J, tolerance);
        Plane pyMax = new Plane(new Vector3D(0.0, yMax, 0.0), Vector3D.PLUS_J, tolerance);
        Plane pzMin = new Plane(new Vector3D(0.0, 0.0, zMin), Vector3D.MINUS_K, tolerance);
        Plane pzMax = new Plane(new Vector3D(0.0, 0.0, zMax), Vector3D.PLUS_K, tolerance);
        RegionFactory factory = new RegionFactory();
        return factory.buildConvex(new Plane[]{pxMin, pxMax, pyMin, pyMax, pzMin, pzMax}).getTree(false);
    }

    private static List<SubPlane> buildBoundary(List<Vector3D> vertices, List<int[]> facets, double tolerance) {
        for (int i = 0; i < vertices.size() - 1; ++i) {
            Vector3D vi = vertices.get(i);
            for (int j = i + 1; j < vertices.size(); ++j) {
                if (!(Vector3D.distance(vi, vertices.get(j)) <= tolerance)) continue;
                throw new MathIllegalArgumentException((Localizable)LocalizedGeometryFormats.CLOSE_VERTICES, new Object[]{vi.getX(), vi.getY(), vi.getZ()});
            }
        }
        int[][] references = PolyhedronsSet.findReferences(vertices, facets);
        int[][] successors = PolyhedronsSet.successors(vertices, facets, references);
        for (int vA = 0; vA < vertices.size(); ++vA) {
            for (int vB : successors[vA]) {
                if (vB < 0) continue;
                boolean found = false;
                for (int v : successors[vB]) {
                    found = found || v == vA;
                }
                if (found) continue;
                Vector3D start = vertices.get(vA);
                Vector3D end = vertices.get(vB);
                throw new MathIllegalArgumentException((Localizable)LocalizedGeometryFormats.EDGE_CONNECTED_TO_ONE_FACET, new Object[]{start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ()});
            }
        }
        ArrayList<SubPlane> boundary = new ArrayList<SubPlane>();
        Object object = facets.iterator();
        while (object.hasNext()) {
            int[] facet = (int[])object.next();
            Plane plane = new Plane(vertices.get(facet[0]), vertices.get(facet[1]), vertices.get(facet[2]), tolerance);
            Vector2D[] two2Points = new Vector2D[facet.length];
            for (int i = 0; i < facet.length; ++i) {
                Vector3D v = vertices.get(facet[i]);
                if (!plane.contains(v)) {
                    throw new MathIllegalArgumentException((Localizable)LocalizedGeometryFormats.OUT_OF_PLANE, new Object[]{v.getX(), v.getY(), v.getZ()});
                }
                two2Points[i] = plane.toSubSpace(v);
            }
            boundary.add(new SubPlane(plane, new PolygonsSet(tolerance, two2Points)));
        }
        return boundary;
    }

    /*
     * WARNING - void declaration
     */
    private static int[][] findReferences(List<Vector3D> vertices, List<int[]> facets) {
        void var5_8;
        int[][] references;
        int[] nbFacets = new int[vertices.size()];
        int maxFacets = 0;
        for (int[] nArray : facets) {
            if (nArray.length < 3) {
                throw new MathIllegalArgumentException((Localizable)LocalizedCoreFormats.WRONG_NUMBER_OF_POINTS, new Object[]{3, nArray.length, true});
            }
            int[] nArray2 = nArray;
            int n = nArray2.length;
            for (int i = 0; i < n; ++i) {
                int index;
                int n2 = index = nArray2[i];
                int n3 = nbFacets[n2] + 1;
                nbFacets[n2] = n3;
                maxFacets = FastMath.max((int)maxFacets, (int)n3);
            }
        }
        for (int[] r : references = new int[vertices.size()][maxFacets]) {
            Arrays.fill(r, -1);
        }
        boolean bl = false;
        while (var5_8 < facets.size()) {
            for (int v : facets.get((int)var5_8)) {
                for (int k = 0; k < maxFacets && references[v][k] >= 0; ++k) {
                }
                references[v][k] = var5_8;
            }
            ++var5_8;
        }
        return references;
    }

    private static int[][] successors(List<Vector3D> vertices, List<int[]> facets, int[][] references) {
        int[][] successors;
        for (int[] s : successors = new int[vertices.size()][references[0].length]) {
            Arrays.fill(s, -1);
        }
        for (int v = 0; v < vertices.size(); ++v) {
            for (int k = 0; k < successors[v].length && references[v][k] >= 0; ++k) {
                int i;
                int[] facet = facets.get(references[v][k]);
                for (i = 0; i < facet.length && facet[i] != v; ++i) {
                }
                successors[v][k] = facet[(i + 1) % facet.length];
                for (int l = 0; l < k; ++l) {
                    if (successors[v][l] != successors[v][k]) continue;
                    Vector3D start = vertices.get(v);
                    Vector3D end = vertices.get(successors[v][k]);
                    throw new MathIllegalArgumentException((Localizable)LocalizedGeometryFormats.FACET_ORIENTATION_MISMATCH, new Object[]{start.getX(), start.getY(), start.getZ(), end.getX(), end.getY(), end.getZ()});
                }
            }
        }
        return successors;
    }

    public PolyhedronsSet buildNew(BSPTree<Euclidean3D, Vector3D, Plane, SubPlane> tree) {
        return new PolyhedronsSet(tree, this.getTolerance());
    }

    @Override
    public Vector3D getInteriorPoint() {
        InteriorPointFinder finder = new InteriorPointFinder(Vector3D.ZERO);
        this.getTree(false).visit(finder);
        BSPTree.InteriorPoint interior = finder.getPoint();
        return interior == null ? null : interior.getPoint();
    }

    public BRep getBRep() throws MathRuntimeException {
        BRepExtractor extractor = new BRepExtractor(this.getTolerance());
        this.getTree(true).visit(extractor);
        return extractor.getBRep();
    }

    @Override
    protected void computeGeometricalProperties() {
        this.getTree(true).visit(new FacetsContributionVisitor());
        if (this.getSize() < 0.0) {
            this.setSize(Double.POSITIVE_INFINITY);
            this.setBarycenter(Vector3D.NaN);
        } else {
            this.setSize(this.getSize() / 3.0);
            this.setBarycenter(new Vector3D(1.0 / (4.0 * this.getSize()), (Vector3D)this.getBarycenter()));
        }
    }

    public SubHyperplane<Euclidean3D, Vector3D, Plane, SubPlane> firstIntersection(Vector3D point, Line line) {
        return this.recurseFirstIntersection(this.getTree(true), point, line);
    }

    private SubPlane recurseFirstIntersection(BSPTree<Euclidean3D, Vector3D, Plane, SubPlane> node, Vector3D point, Line line) {
        SubPlane facet;
        Vector3D hit3D;
        SubPlane facet2;
        BSPTree<Euclidean3D, Vector3D, Plane, SubPlane> far;
        BSPTree<Euclidean3D, Vector3D, Plane, SubPlane> near;
        boolean in;
        SubPlane cut = node.getCut();
        if (cut == null) {
            return null;
        }
        BSPTree<Euclidean3D, Vector3D, Plane, SubPlane> minus = node.getMinus();
        BSPTree<Euclidean3D, Vector3D, Plane, SubPlane> plus = node.getPlus();
        double offset = ((Plane)cut.getHyperplane()).getOffset(point);
        boolean bl = in = FastMath.abs((double)offset) < this.getTolerance();
        if (offset < 0.0) {
            near = minus;
            far = plus;
        } else {
            near = plus;
            far = minus;
        }
        if (in && (facet2 = this.boundaryFacet(point, node)) != null) {
            return facet2;
        }
        SubPlane crossed = this.recurseFirstIntersection(near, point, line);
        if (crossed != null) {
            return crossed;
        }
        if (!in && (hit3D = ((Plane)cut.getHyperplane()).intersection(line)) != null && line.getAbscissa(hit3D) > line.getAbscissa(point) && (facet = this.boundaryFacet(hit3D, node)) != null) {
            return facet;
        }
        return this.recurseFirstIntersection(far, point, line);
    }

    private SubPlane boundaryFacet(Vector3D point, BSPTree<Euclidean3D, Vector3D, Plane, SubPlane> node) {
        Vector2D point2D = ((Plane)node.getCut().getHyperplane()).toSubSpace(point);
        BoundaryAttribute attribute = (BoundaryAttribute)node.getAttribute();
        if (attribute.getPlusOutside() != null && ((SubPlane)attribute.getPlusOutside()).getRemainingRegion().checkPoint(point2D) != Region.Location.OUTSIDE) {
            return (SubPlane)attribute.getPlusOutside();
        }
        if (attribute.getPlusInside() != null && ((SubPlane)attribute.getPlusInside()).getRemainingRegion().checkPoint(point2D) != Region.Location.OUTSIDE) {
            return (SubPlane)attribute.getPlusInside();
        }
        return null;
    }

    public PolyhedronsSet rotate(Vector3D center, Rotation rotation) {
        return (PolyhedronsSet)this.applyTransform(new RotationTransform(center, rotation));
    }

    public PolyhedronsSet translate(Vector3D translation) {
        return (PolyhedronsSet)this.applyTransform(new TranslationTransform(translation));
    }

    public static class BRep {
        private final List<Vector3D> vertices;
        private final List<int[]> facets;

        public BRep(List<Vector3D> vertices, List<int[]> facets) {
            this.vertices = vertices;
            this.facets = facets;
        }

        public List<Vector3D> getVertices() {
            return this.vertices;
        }

        public List<int[]> getFacets() {
            return this.facets;
        }
    }

    private static class BRepExtractor
    implements BSPTreeVisitor<Euclidean3D, Vector3D, Plane, SubPlane> {
        private final double tolerance;
        private final List<Vector3D> vertices;
        private final List<int[]> facets;

        BRepExtractor(double tolerance) {
            this.tolerance = tolerance;
            this.vertices = new ArrayList<Vector3D>();
            this.facets = new ArrayList<int[]>();
        }

        public BRep getBRep() {
            return new BRep(this.vertices, this.facets);
        }

        @Override
        public BSPTreeVisitor.Order visitOrder(BSPTree<Euclidean3D, Vector3D, Plane, SubPlane> node) {
            return BSPTreeVisitor.Order.MINUS_SUB_PLUS;
        }

        @Override
        public void visitInternalNode(BSPTree<Euclidean3D, Vector3D, Plane, SubPlane> node) {
            BoundaryAttribute attribute = (BoundaryAttribute)node.getAttribute();
            if (attribute.getPlusOutside() != null) {
                this.addContribution((SubPlane)attribute.getPlusOutside(), false);
            }
            if (attribute.getPlusInside() != null) {
                this.addContribution((SubPlane)attribute.getPlusInside(), true);
            }
        }

        @Override
        public void visitLeafNode(BSPTree<Euclidean3D, Vector3D, Plane, SubPlane> node) {
        }

        private void addContribution(SubPlane facet, boolean reversed) throws MathRuntimeException {
            PolygonsSet polygon = (PolygonsSet)facet.getRemainingRegion();
            Vector2D[][] loops2D = polygon.getVertices();
            if (loops2D.length == 0) {
                throw new MathRuntimeException((Localizable)LocalizedGeometryFormats.OUTLINE_BOUNDARY_LOOP_OPEN, new Object[0]);
            }
            if (loops2D.length > 1) {
                throw new MathRuntimeException((Localizable)LocalizedGeometryFormats.FACET_WITH_SEVERAL_BOUNDARY_LOOPS, new Object[0]);
            }
            for (Vector2D[] loop2D : polygon.getVertices()) {
                int[] loop3D = new int[loop2D.length];
                for (int i = 0; i < loop2D.length; ++i) {
                    if (loop2D[i] == null) {
                        throw new MathRuntimeException((Localizable)LocalizedGeometryFormats.OUTLINE_BOUNDARY_LOOP_OPEN, new Object[0]);
                    }
                    loop3D[reversed ? loop2D.length - 1 - i : i] = this.getVertexIndex(((Plane)facet.getHyperplane()).toSpace(loop2D[i]));
                }
                this.facets.add(loop3D);
            }
        }

        private int getVertexIndex(Vector3D vertex) {
            for (int i = 0; i < this.vertices.size(); ++i) {
                if (!(Vector3D.distance(vertex, this.vertices.get(i)) <= this.tolerance)) continue;
                return i;
            }
            this.vertices.add(vertex);
            return this.vertices.size() - 1;
        }
    }

    private class FacetsContributionVisitor
    implements BSPTreeVisitor<Euclidean3D, Vector3D, Plane, SubPlane> {
        FacetsContributionVisitor() {
            PolyhedronsSet.this.setSize(0.0);
            PolyhedronsSet.this.setBarycenter(new Vector3D(0.0, 0.0, 0.0));
        }

        @Override
        public BSPTreeVisitor.Order visitOrder(BSPTree<Euclidean3D, Vector3D, Plane, SubPlane> node) {
            return BSPTreeVisitor.Order.MINUS_SUB_PLUS;
        }

        @Override
        public void visitInternalNode(BSPTree<Euclidean3D, Vector3D, Plane, SubPlane> node) {
            BoundaryAttribute attribute = (BoundaryAttribute)node.getAttribute();
            if (attribute.getPlusOutside() != null) {
                this.addContribution((SubPlane)attribute.getPlusOutside(), false);
            }
            if (attribute.getPlusInside() != null) {
                this.addContribution((SubPlane)attribute.getPlusInside(), true);
            }
        }

        @Override
        public void visitLeafNode(BSPTree<Euclidean3D, Vector3D, Plane, SubPlane> node) {
        }

        private void addContribution(SubPlane facet, boolean reversed) {
            Region polygon = facet.getRemainingRegion();
            double area = polygon.getSize();
            if (Double.isInfinite(area)) {
                PolyhedronsSet.this.setSize(Double.POSITIVE_INFINITY);
                PolyhedronsSet.this.setBarycenter(Vector3D.NaN);
            } else {
                Plane plane = (Plane)facet.getHyperplane();
                Vector3D facetB = plane.toSpace((Vector2D)polygon.getBarycenter());
                double scaled = area * facetB.dotProduct(plane.getNormal());
                if (reversed) {
                    scaled = -scaled;
                }
                PolyhedronsSet.this.setSize(PolyhedronsSet.this.getSize() + scaled);
                PolyhedronsSet.this.setBarycenter(new Vector3D(1.0, (Vector3D)PolyhedronsSet.this.getBarycenter(), scaled, facetB));
            }
        }
    }

    private static class RotationTransform
    implements Transform<Euclidean3D, Vector3D, Plane, SubPlane, Euclidean2D, Vector2D, org.hipparchus.geometry.euclidean.twod.Line, SubLine> {
        private final Vector3D center;
        private final Rotation rotation;
        private Plane cachedOriginal;
        private Transform<Euclidean2D, Vector2D, org.hipparchus.geometry.euclidean.twod.Line, SubLine, Euclidean1D, Vector1D, OrientedPoint, SubOrientedPoint> cachedTransform;

        RotationTransform(Vector3D center, Rotation rotation) {
            this.center = center;
            this.rotation = rotation;
        }

        @Override
        public Vector3D apply(Vector3D point) {
            Vector3D delta = point.subtract(this.center);
            return new Vector3D(1.0, this.center, 1.0, this.rotation.applyTo(delta));
        }

        @Override
        public Plane apply(Plane hyperplane) {
            return hyperplane.rotate(this.center, this.rotation);
        }

        @Override
        public SubLine apply(SubLine sub, Plane original, Plane transformed) {
            if (original != this.cachedOriginal) {
                Vector3D p00 = original.getOrigin();
                Vector3D p10 = original.toSpace(new Vector2D(1.0, 0.0));
                Vector3D p01 = original.toSpace(new Vector2D(0.0, 1.0));
                Vector2D tP00 = transformed.toSubSpace(this.apply(p00));
                Vector2D tP10 = transformed.toSubSpace(this.apply(p10));
                Vector2D tP01 = transformed.toSubSpace(this.apply(p01));
                this.cachedOriginal = original;
                this.cachedTransform = org.hipparchus.geometry.euclidean.twod.Line.getTransform(tP10.getX() - tP00.getX(), tP10.getY() - tP00.getY(), tP01.getX() - tP00.getX(), tP01.getY() - tP00.getY(), tP00.getX(), tP00.getY());
            }
            return sub.applyTransform(this.cachedTransform);
        }
    }

    private static class TranslationTransform
    implements Transform<Euclidean3D, Vector3D, Plane, SubPlane, Euclidean2D, Vector2D, org.hipparchus.geometry.euclidean.twod.Line, SubLine> {
        private final Vector3D translation;
        private Plane cachedOriginal;
        private Transform<Euclidean2D, Vector2D, org.hipparchus.geometry.euclidean.twod.Line, SubLine, Euclidean1D, Vector1D, OrientedPoint, SubOrientedPoint> cachedTransform;

        TranslationTransform(Vector3D translation) {
            this.translation = translation;
        }

        @Override
        public Vector3D apply(Vector3D point) {
            return new Vector3D(1.0, point, 1.0, this.translation);
        }

        @Override
        public Plane apply(Plane hyperplane) {
            return hyperplane.translate(this.translation);
        }

        @Override
        public SubLine apply(SubLine sub, Plane original, Plane transformed) {
            if (original != this.cachedOriginal) {
                Vector2D shift = transformed.toSubSpace(this.apply(original.getOrigin()));
                this.cachedOriginal = original;
                this.cachedTransform = org.hipparchus.geometry.euclidean.twod.Line.getTransform(1.0, 0.0, 0.0, 1.0, shift.getX(), shift.getY());
            }
            return sub.applyTransform(this.cachedTransform);
        }
    }
}

