/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators.bv;

import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.metadata.ConstraintDescriptor;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidator;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorContext;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorInitializationContext;
import org.hibernate.validator.internal.engine.messageinterpolation.util.InterpolationHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class PatternValidator
implements HibernateConstraintValidator<Pattern, CharSequence> {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
    private java.util.regex.Pattern pattern;
    private String escapedRegexp;

    @Override
    public void initialize(ConstraintDescriptor<Pattern> constraintDescriptor, HibernateConstraintValidatorInitializationContext initializationContext) {
        Pattern parameters = (Pattern)constraintDescriptor.getAnnotation();
        Pattern.Flag[] flags = parameters.flags();
        int intFlag = 0;
        for (Pattern.Flag flag : flags) {
            intFlag |= flag.getValue();
        }
        try {
            this.pattern = initializationContext.getSharedData(PatternConstraintInitializer.class, PatternConstraintInitializer::getInstance).of(parameters.regexp(), intFlag);
        }
        catch (PatternSyntaxException e) {
            throw LOG.getInvalidRegularExpressionException(e);
        }
        this.escapedRegexp = InterpolationHelper.escapeMessageParameter(parameters.regexp());
    }

    public boolean isValid(CharSequence value, ConstraintValidatorContext constraintValidatorContext) {
        if (value == null) {
            return true;
        }
        if (constraintValidatorContext instanceof HibernateConstraintValidatorContext) {
            ((HibernateConstraintValidatorContext)constraintValidatorContext.unwrap(HibernateConstraintValidatorContext.class)).addMessageParameter("regexp", this.escapedRegexp);
        }
        Matcher m = this.pattern.matcher(value);
        return m.matches();
    }

    private static final class PatternConstraintInitializer {
        private final Map<PatternKey, java.util.regex.Pattern> cache = new ConcurrentHashMap<PatternKey, java.util.regex.Pattern>();

        public static PatternConstraintInitializer getInstance() {
            return new PatternConstraintInitializer();
        }

        private PatternConstraintInitializer() {
        }

        public java.util.regex.Pattern of(String pattern, int flags) {
            return this.cache.computeIfAbsent(new PatternKey(pattern, flags), key -> java.util.regex.Pattern.compile(pattern, flags));
        }

        private record PatternKey(String pattern, int flags) {
        }
    }
}

