/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.tree.impl;

import java.util.Optional;
import java.util.function.BiFunction;
import org.hibernate.search.engine.common.tree.TreeFilterDefinition;
import org.hibernate.search.engine.common.tree.spi.TreeContributionListener;
import org.hibernate.search.engine.common.tree.spi.TreeFilterPathTracker;
import org.hibernate.search.engine.common.tree.spi.TreeNestingContext;
import org.hibernate.search.engine.common.tree.spi.TreeNodeInclusion;
import org.hibernate.search.engine.mapper.model.spi.MappingElement;
import org.hibernate.search.util.common.SearchException;

public final class NotifyingTreeNestingContext
implements TreeNestingContext {
    private final TreeNestingContext delegate;
    private final TreeContributionListener listener;

    public NotifyingTreeNestingContext(TreeNestingContext delegate, TreeContributionListener listener) {
        this.delegate = delegate;
        this.listener = listener;
    }

    @Override
    public <T> T nest(String relativeName, TreeNestingContext.LeafFactory<T> factory) {
        return (T)this.delegate.nest(relativeName, (String prefixedName, TreeNodeInclusion inclusion) -> {
            if (TreeNodeInclusion.INCLUDED.equals((Object)inclusion)) {
                this.listener.onNodeContributed();
            }
            return factory.create(prefixedName, inclusion);
        });
    }

    @Override
    public <T> T nest(String relativeName, TreeNestingContext.CompositeFactory<T> factory) {
        return (T)this.delegate.nest(relativeName, (String prefixedName, TreeNodeInclusion inclusion, TreeNestingContext nestedNestingContext) -> {
            if (TreeNodeInclusion.INCLUDED.equals((Object)inclusion)) {
                this.listener.onNodeContributed();
            }
            return factory.create(prefixedName, inclusion, nestedNestingContext);
        });
    }

    @Override
    public <T> T nestUnfiltered(TreeNestingContext.UnfilteredFactory<T> factory) {
        return (T)this.delegate.nestUnfiltered((inclusion, prefix) -> {
            if (TreeNodeInclusion.INCLUDED.equals((Object)inclusion)) {
                this.listener.onNodeContributed();
            }
            return factory.create(inclusion, prefix);
        });
    }

    @Override
    public <T> Optional<T> nestComposed(MappingElement mappingElement, String relativePrefix, TreeFilterDefinition definition, TreeFilterPathTracker pathTracker, TreeNestingContext.NestedContextBuilder<T> contextBuilder, BiFunction<MappingElement, String, SearchException> cyclicRecursionExceptionFactory) {
        Optional<T> result = this.delegate.nestComposed(mappingElement, relativePrefix, definition, pathTracker, contextBuilder, cyclicRecursionExceptionFactory);
        if (result.isPresent()) {
            this.listener.onNodeContributed();
        }
        return result;
    }
}

