/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.hibernate.search.backend.lucene.analysis.model.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.AnalyzerConstants;
import org.hibernate.search.backend.lucene.search.predicate.impl.LucenePredicateTypeKeys;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneFieldProjection;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LuceneTextTermsAggregation;
import org.hibernate.search.backend.lucene.types.codec.impl.DocValues;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneStringFieldCodec;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexValueFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneExistsPredicate;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneSimpleQueryStringPredicateBuilderFieldState;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextMatchPredicate;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextPhrasePredicate;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextRangePredicate;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextRegexpPredicate;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextTermsPredicate;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneTextWildcardPredicate;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneStandardFieldSort;
import org.hibernate.search.engine.backend.types.Norms;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.backend.types.TermVector;
import org.hibernate.search.engine.backend.types.dsl.StringIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.search.aggregation.spi.AggregationTypeKeys;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;
import org.hibernate.search.engine.search.projection.spi.ProjectionTypeKeys;
import org.hibernate.search.engine.search.sort.spi.SortTypeKeys;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class LuceneStringIndexFieldTypeOptionsStep
extends AbstractLuceneStandardIndexFieldTypeOptionsStep<LuceneStringIndexFieldTypeOptionsStep, String>
implements StringIndexFieldTypeOptionsStep<LuceneStringIndexFieldTypeOptionsStep> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private String analyzerName;
    private Analyzer analyzer;
    private String searchAnalyzerName;
    private Analyzer searchAnalyzer;
    private String normalizerName;
    private Analyzer normalizer;
    private Norms norms = Norms.DEFAULT;
    private TermVector termVector = TermVector.DEFAULT;
    private Sortable sortable = Sortable.DEFAULT;

    LuceneStringIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext) {
        super(buildContext, String.class);
    }

    public LuceneStringIndexFieldTypeOptionsStep analyzer(String analyzerName) {
        this.analyzerName = analyzerName;
        this.analyzer = this.getAnalysisDefinitionRegistry().getAnalyzerDefinition(analyzerName);
        if (this.analyzer == null) {
            throw log.unknownAnalyzer(analyzerName, this.buildContext.getEventContext());
        }
        return this;
    }

    public LuceneStringIndexFieldTypeOptionsStep searchAnalyzer(String searchAnalyzerName) {
        this.searchAnalyzerName = searchAnalyzerName;
        this.searchAnalyzer = this.getAnalysisDefinitionRegistry().getAnalyzerDefinition(searchAnalyzerName);
        if (this.searchAnalyzer == null) {
            throw log.unknownAnalyzer(searchAnalyzerName, this.buildContext.getEventContext());
        }
        return this;
    }

    public LuceneStringIndexFieldTypeOptionsStep normalizer(String normalizerName) {
        this.normalizerName = normalizerName;
        this.normalizer = this.getAnalysisDefinitionRegistry().getNormalizerDefinition(normalizerName);
        if (this.normalizer == null) {
            throw log.unknownNormalizer(normalizerName, this.buildContext.getEventContext());
        }
        return this;
    }

    public LuceneStringIndexFieldTypeOptionsStep norms(Norms norms) {
        this.norms = norms;
        return this;
    }

    public LuceneStringIndexFieldTypeOptionsStep termVector(TermVector termVector) {
        this.termVector = termVector;
        return this;
    }

    public LuceneStringIndexFieldTypeOptionsStep sortable(Sortable sortable) {
        this.sortable = sortable;
        return this;
    }

    @Override
    public LuceneIndexValueFieldType<String> toIndexFieldType() {
        DocValues docValues;
        boolean resolvedSortable = LuceneStringIndexFieldTypeOptionsStep.resolveDefault(this.sortable);
        boolean resolvedProjectable = LuceneStringIndexFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedSearchable = LuceneStringIndexFieldTypeOptionsStep.resolveDefault(this.searchable);
        boolean resolvedAggregable = LuceneStringIndexFieldTypeOptionsStep.resolveDefault(this.aggregable);
        boolean resolvedNorms = this.resolveNorms();
        ResolvedTermVector resolvedTermVector = this.resolveTermVector();
        DocValues docValues2 = docValues = resolvedSortable || resolvedAggregable ? DocValues.ENABLED : DocValues.DISABLED;
        if (this.analyzer != null) {
            this.builder.analyzerName(this.analyzerName);
            this.builder.searchAnalyzerName(this.searchAnalyzerName);
            this.builder.indexingAnalyzerOrNormalizer(this.analyzer);
            this.builder.searchAnalyzerOrNormalizer(this.searchAnalyzer != null ? this.searchAnalyzer : this.analyzer);
            if (resolvedSortable) {
                throw log.cannotUseAnalyzerOnSortableField(this.analyzerName, this.buildContext.getEventContext());
            }
            if (this.normalizer != null) {
                throw log.cannotApplyAnalyzerAndNormalizer(this.analyzerName, this.normalizerName, this.buildContext.getEventContext());
            }
            if (this.indexNullAsValue != null) {
                throw log.cannotUseIndexNullAsAndAnalyzer(this.analyzerName, (String)this.indexNullAsValue, this.buildContext.getEventContext());
            }
            if (resolvedAggregable) {
                throw log.cannotUseAnalyzerOnAggregableField(this.analyzerName, this.buildContext.getEventContext());
            }
        } else {
            if (this.normalizer != null) {
                this.builder.normalizerName(this.normalizerName);
                this.builder.searchAnalyzerName(this.searchAnalyzerName);
                this.builder.indexingAnalyzerOrNormalizer(this.normalizer);
                this.builder.searchAnalyzerOrNormalizer(this.searchAnalyzer != null ? this.searchAnalyzer : this.normalizer);
            } else {
                this.builder.indexingAnalyzerOrNormalizer(AnalyzerConstants.KEYWORD_ANALYZER);
                this.builder.searchAnalyzerOrNormalizer(AnalyzerConstants.KEYWORD_ANALYZER);
            }
            if (this.searchAnalyzer != null) {
                throw log.searchAnalyzerWithoutAnalyzer(this.searchAnalyzerName, this.buildContext.getEventContext());
            }
        }
        LuceneStringFieldCodec codec = new LuceneStringFieldCodec(LuceneStringIndexFieldTypeOptionsStep.getFieldType(resolvedProjectable, resolvedSearchable, this.analyzer != null, resolvedNorms, resolvedTermVector), docValues, (String)this.indexNullAsValue, this.builder.indexingAnalyzerOrNormalizer());
        this.builder.codec(codec);
        if (resolvedSearchable) {
            this.builder.searchable(true);
            this.builder.queryElementFactory(PredicateTypeKeys.MATCH, new LuceneTextMatchPredicate.Factory<String>(codec));
            this.builder.queryElementFactory(PredicateTypeKeys.RANGE, new LuceneTextRangePredicate.Factory<String>(codec));
            this.builder.queryElementFactory(PredicateTypeKeys.TERMS, new LuceneTextTermsPredicate.Factory<String>(codec));
            if (resolvedNorms) {
                this.builder.queryElementFactory(PredicateTypeKeys.EXISTS, new LuceneExistsPredicate.NormsBasedFactory());
            } else {
                this.builder.queryElementFactory(PredicateTypeKeys.EXISTS, DocValues.ENABLED.equals((Object)docValues) ? new LuceneExistsPredicate.DocValuesBasedFactory() : new LuceneExistsPredicate.DefaultFactory());
            }
            this.builder.queryElementFactory(PredicateTypeKeys.PHRASE, new LuceneTextPhrasePredicate.Factory());
            this.builder.queryElementFactory(PredicateTypeKeys.WILDCARD, new LuceneTextWildcardPredicate.Factory());
            this.builder.queryElementFactory(PredicateTypeKeys.REGEXP, new LuceneTextRegexpPredicate.Factory());
            this.builder.queryElementFactory(LucenePredicateTypeKeys.SIMPLE_QUERY_STRING, new LuceneSimpleQueryStringPredicateBuilderFieldState.Factory());
        }
        if (resolvedSortable) {
            this.builder.sortable(true);
            this.builder.queryElementFactory(SortTypeKeys.FIELD, new LuceneStandardFieldSort.TextFieldFactory<String>(codec));
        }
        if (resolvedProjectable) {
            this.builder.projectable(true);
            this.builder.queryElementFactory(ProjectionTypeKeys.FIELD, new LuceneFieldProjection.Factory<String>(codec));
        }
        if (resolvedAggregable) {
            this.builder.aggregable(true);
            this.builder.queryElementFactory(AggregationTypeKeys.TERMS, new LuceneTextTermsAggregation.Factory());
        }
        return this.builder.build();
    }

    @Override
    protected LuceneStringIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }

    private LuceneAnalysisDefinitionRegistry getAnalysisDefinitionRegistry() {
        return this.buildContext.getAnalysisDefinitionRegistry();
    }

    private boolean resolveNorms() {
        switch (this.norms) {
            case YES: {
                return true;
            }
            case NO: {
                return false;
            }
            case DEFAULT: {
                return this.analyzerName != null;
            }
        }
        throw new AssertionFailure("Unexpected value for Norms: " + this.norms);
    }

    private ResolvedTermVector resolveTermVector() {
        switch (this.termVector) {
            case NO: 
            case DEFAULT: {
                return new ResolvedTermVector(false, false, false, false);
            }
            case YES: {
                return new ResolvedTermVector(true, false, false, false);
            }
            case WITH_POSITIONS: {
                return new ResolvedTermVector(true, true, false, false);
            }
            case WITH_OFFSETS: {
                return new ResolvedTermVector(true, false, true, false);
            }
            case WITH_POSITIONS_OFFSETS: {
                return new ResolvedTermVector(true, true, true, false);
            }
            case WITH_POSITIONS_PAYLOADS: {
                return new ResolvedTermVector(true, true, false, true);
            }
            case WITH_POSITIONS_OFFSETS_PAYLOADS: {
                return new ResolvedTermVector(true, true, true, true);
            }
        }
        throw new AssertionFailure("Unexpected value for TermVector: " + this.termVector);
    }

    private static FieldType getFieldType(boolean projectable, boolean searchable, boolean analyzed, boolean norms, ResolvedTermVector termVector) {
        FieldType fieldType = new FieldType();
        if (!searchable) {
            if (!projectable) {
                return null;
            }
            fieldType.setIndexOptions(IndexOptions.NONE);
            fieldType.setStored(true);
            fieldType.freeze();
            return fieldType;
        }
        if (analyzed) {
            fieldType.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            termVector.applyTo(fieldType);
            fieldType.setTokenized(true);
        } else {
            fieldType.setIndexOptions(IndexOptions.DOCS);
            fieldType.setTokenized(true);
        }
        fieldType.setStored(projectable);
        fieldType.setOmitNorms(!norms);
        fieldType.freeze();
        return fieldType;
    }

    private static final class ResolvedTermVector {
        private final boolean store;
        private final boolean positions;
        private final boolean offsets;
        private final boolean payloads;

        private ResolvedTermVector(boolean store, boolean positions, boolean offsets, boolean payloads) {
            this.store = store;
            this.positions = positions;
            this.offsets = offsets;
            this.payloads = payloads;
        }

        private void applyTo(FieldType fieldType) {
            fieldType.setStoreTermVectors(this.store);
            fieldType.setStoreTermVectorPositions(this.positions);
            fieldType.setStoreTermVectorOffsets(this.offsets);
            fieldType.setStoreTermVectorPayloads(this.payloads);
        }
    }
}

