/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.common.impl.AbstractLuceneCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractLuceneProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.FieldProjectionBuilder;
import org.hibernate.search.engine.search.projection.spi.ProjectionAccumulator;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneFieldProjection<E, P, F, V>
extends AbstractLuceneProjection<E, P> {
    private final String absoluteFieldPath;
    private final String nestedDocumentPath;
    private final LuceneFieldCodec<F> codec;
    private final ProjectionConverter<F, ? extends V> converter;
    private final ProjectionAccumulator<F, V, E, P> accumulator;

    private LuceneFieldProjection(Builder<F, V> builder, ProjectionAccumulator<F, V, E, P> accumulator) {
        super(builder);
        this.absoluteFieldPath = ((Builder)builder).field.absolutePath();
        this.nestedDocumentPath = ((Builder)builder).field.nestedDocumentPath();
        this.codec = ((Builder)builder).codec;
        this.converter = ((Builder)builder).converter;
        this.accumulator = accumulator;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[absoluteFieldPath=" + this.absoluteFieldPath + ", accumulator=" + this.accumulator + "]";
    }

    @Override
    public void request(SearchProjectionRequestContext context) {
        context.requireStoredField(this.absoluteFieldPath, this.nestedDocumentPath);
    }

    @Override
    public E extract(ProjectionHitMapper<?, ?> mapper, LuceneResult documentResult, SearchProjectionExtractContext context) {
        Object extracted = this.accumulator.createInitial();
        for (IndexableField field : documentResult.getDocument().getFields()) {
            if (!field.name().equals(this.absoluteFieldPath)) continue;
            F decoded = this.codec.decode(field);
            extracted = this.accumulator.accumulate(extracted, decoded);
        }
        return (E)extracted;
    }

    @Override
    public P transform(LoadingResult<?, ?> loadingResult, E extractedData, SearchProjectionTransformContext context) {
        FromDocumentValueConvertContext convertContext = context.fromDocumentValueConvertContext();
        return (P)this.accumulator.finish(extractedData, this.converter, convertContext);
    }

    private static class Builder<F, V>
    extends AbstractLuceneProjection.AbstractBuilder<V>
    implements FieldProjectionBuilder<V> {
        private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
        private final LuceneFieldCodec<F> codec;
        private final LuceneSearchIndexValueFieldContext<F> field;
        private final ProjectionConverter<F, ? extends V> converter;

        private Builder(LuceneFieldCodec<F> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field, ProjectionConverter<F, ? extends V> converter) {
            super(scope);
            this.codec = codec;
            this.field = field;
            this.converter = converter;
        }

        public <P> SearchProjection<P> build(ProjectionAccumulator.Provider<V, P> accumulatorProvider) {
            if (accumulatorProvider.isSingleValued() && this.field.multiValuedInRoot()) {
                throw log.invalidSingleValuedProjectionOnMultiValuedField(this.field.absolutePath(), this.field.eventContext());
            }
            return new LuceneFieldProjection(this, accumulatorProvider.get());
        }
    }

    private static class TypeSelector<F>
    implements FieldProjectionBuilder.TypeSelector {
        private final LuceneFieldCodec<F> codec;
        private final LuceneSearchIndexScope<?> scope;
        private final LuceneSearchIndexValueFieldContext<F> field;

        private TypeSelector(LuceneFieldCodec<F> codec, LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            this.codec = codec;
            this.scope = scope;
            this.field = field;
        }

        public <V> Builder<F, V> type(Class<V> expectedType, ValueConvert convert) {
            return new Builder(this.codec, this.scope, this.field, this.field.type().projectionConverter(convert).withConvertedType(expectedType, this.field));
        }
    }

    public static class Factory<F>
    extends AbstractLuceneCodecAwareSearchQueryElementFactory<FieldProjectionBuilder.TypeSelector, F, LuceneFieldCodec<F>> {
        public Factory(LuceneFieldCodec<F> codec) {
            super(codec);
        }

        @Override
        public TypeSelector<?> create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<F> field) {
            field.nestedPathHierarchy();
            return new TypeSelector(this.codec, scope, field);
        }
    }
}

