/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.util.Set;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicate;
import org.hibernate.search.backend.lucene.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilder;

public abstract class AbstractLuceneSearchPredicate
implements LuceneSearchPredicate {
    protected final Set<String> indexNames;
    private final Float boost;
    private final boolean constantScore;

    protected AbstractLuceneSearchPredicate(AbstractBuilder builder) {
        this.indexNames = builder.scope.hibernateSearchIndexNames();
        this.boost = builder.boost;
        this.constantScore = builder.constantScore;
    }

    @Override
    public Set<String> indexNames() {
        return this.indexNames;
    }

    @Override
    public Query toQuery(PredicateRequestContext context) {
        Query query = this.doToQuery(context);
        if (this.constantScore) {
            query = new ConstantScoreQuery(query);
        }
        if (this.boost != null) {
            query = new BoostQuery(query, this.boost.floatValue());
        }
        return query;
    }

    protected abstract Query doToQuery(PredicateRequestContext var1);

    public static abstract class AbstractBuilder
    implements SearchPredicateBuilder {
        protected final LuceneSearchIndexScope<?> scope;
        private Float boost;
        private boolean constantScore;

        protected AbstractBuilder(LuceneSearchIndexScope<?> scope) {
            this.scope = scope;
        }

        public void boost(float boost) {
            this.boost = Float.valueOf(boost);
        }

        public void constantScore() {
            this.constantScore = true;
        }
    }
}

