/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;

public final class IdentifierCollector
extends SimpleCollector {
    public static final CollectorKey<IdentifierCollector> KEY = CollectorKey.create();
    public static final CollectorFactory<IdentifierCollector> FACTORY = new CollectorFactory<IdentifierCollector>(){

        @Override
        public IdentifierCollector createCollector(CollectorExecutionContext context) {
            return new IdentifierCollector();
        }

        @Override
        public CollectorKey<IdentifierCollector> getCollectorKey() {
            return KEY;
        }
    };
    private BinaryDocValues currentLeafIdDocValues;
    private int currentLeafDocBase;
    private Map<Integer, String> collected = new HashMap<Integer, String>();

    private IdentifierCollector() {
    }

    public void collect(int doc) throws IOException {
        this.currentLeafIdDocValues.advance(doc);
        this.collected.put(this.currentLeafDocBase + doc, this.currentLeafIdDocValues.binaryValue().utf8ToString());
    }

    public ScoreMode scoreMode() {
        return ScoreMode.COMPLETE_NO_SCORES;
    }

    public String get(int doc) {
        return this.collected.get(doc);
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.currentLeafIdDocValues = DocValues.getBinary((LeafReader)context.reader(), (String)MetadataFields.idFieldName());
        this.currentLeafDocBase = context.docBase;
    }
}

