/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.hamcrest;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class CollectionElementMatcher<E, C extends Collection<E>>
extends BaseMatcher<C> {
    private final List<Matcher<E>> elementMatchers;

    public static <T> Matcher<Collection<T>> hasAllOf(Matcher<T> ... elementMatchers) {
        return new CollectionElementMatcher(elementMatchers);
    }

    public CollectionElementMatcher(Matcher<E> ... elementMatchers) {
        this.elementMatchers = Arrays.asList(elementMatchers);
    }

    public boolean matches(Object o) {
        assert (o instanceof Collection);
        Collection collection = (Collection)o;
        block0: for (Matcher<E> valueMatcher : this.elementMatchers) {
            for (Object value : collection) {
                if (!valueMatcher.matches(value)) continue;
                continue block0;
            }
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("contained");
    }
}

