/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.hamcrest;

import java.util.Locale;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class CaseInsensitiveStartsWithMatcher
extends TypeSafeMatcher<String> {
    private final String match;

    public CaseInsensitiveStartsWithMatcher(String match) {
        this.match = match.toLowerCase(Locale.ROOT);
    }

    public static Matcher<String> startsWith(String expected) {
        return new CaseInsensitiveStartsWithMatcher(expected);
    }

    protected boolean matchesSafely(String string) {
        String normalized = string.toLowerCase(Locale.ROOT).trim();
        return normalized.startsWith(this.match);
    }

    public void describeTo(Description description) {
        description.appendText("starts with (case insensitive)").appendValue((Object)this.match);
    }
}

