/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.jts;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class EnvelopeAdapter {
    private static volatile GeometryFactory geomFactory = new GeometryFactory();

    private EnvelopeAdapter() {
    }

    public static Polygon toPolygon(Envelope env, int srid) {
        Coordinate[] coords = new Coordinate[]{new Coordinate(env.getMinX(), env.getMinY()), new Coordinate(env.getMinX(), env.getMaxY()), new Coordinate(env.getMaxX(), env.getMaxY()), new Coordinate(env.getMaxX(), env.getMinY()), new Coordinate(env.getMinX(), env.getMinY())};
        LinearRing shell = geomFactory.createLinearRing(coords);
        Polygon pg = geomFactory.createPolygon(shell, null);
        pg.setSRID(srid);
        return pg;
    }

    public static void setGeometryFactory(GeometryFactory gf) {
        geomFactory = gf;
    }
}

