/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.sqlserver;

import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.spatial.HSMessageLogger;
import org.hibernate.spatial.contributor.ContributorImplementor;
import org.hibernate.spatial.dialect.sqlserver.SqlServerGeographyType;
import org.hibernate.spatial.dialect.sqlserver.SqlServerGeometryType;
import org.hibernate.spatial.dialect.sqlserver.SqlServerSqmFunctionDescriptors;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class SqlServerDialectContributor
implements ContributorImplementor {
    private final ServiceRegistry serviceRegistry;

    public SqlServerDialectContributor(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public void contributeJdbcTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        HSMessageLogger.SPATIAL_MSG_LOGGER.typeContributions(this.getClass().getCanonicalName());
        typeContributions.contributeJdbcType((JdbcType)SqlServerGeometryType.INSTANCE);
        typeContributions.contributeJdbcType((JdbcType)SqlServerGeographyType.INSTANCE);
    }

    @Override
    public void contributeFunctions(FunctionContributions functionContributions) {
        HSMessageLogger.SPATIAL_MSG_LOGGER.functionContributions(this.getClass().getCanonicalName());
        SqlServerSqmFunctionDescriptors functions = new SqlServerSqmFunctionDescriptors(functionContributions);
        SqmFunctionRegistry functionRegistry = functionContributions.getFunctionRegistry();
        functions.asMap().forEach((key, desc) -> {
            functionRegistry.register(key.getName(), desc);
            key.getAltName().ifPresent(altName -> functionRegistry.registerAlternateKey(altName, key.getName()));
        });
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }
}

