/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.oracle;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.query.sqm.function.NamedSqmFunctionDescriptor;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.spatial.CommonSpatialFunction;
import org.hibernate.spatial.FunctionKey;
import org.hibernate.spatial.KeyedSqmFunctionDescriptors;
import org.hibernate.spatial.dialect.oracle.OracleSpatialSQLMMFunction;
import org.hibernate.spatial.dialect.oracle.SDOGetGeometryType;
import org.hibernate.spatial.dialect.oracle.SDOMethodDescriptor;
import org.hibernate.spatial.dialect.oracle.SDORelateFunction;
import org.hibernate.spatial.dialect.oracle.STRelateFunction;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;

public class OracleSDOFunctionDescriptors
implements KeyedSqmFunctionDescriptors {
    private final Map<FunctionKey, SqmFunctionDescriptor> map = new HashMap<FunctionKey, SqmFunctionDescriptor>();
    private final BasicTypeRegistry typeRegistry;

    public OracleSDOFunctionDescriptors(FunctionContributions functionContributions) {
        this.typeRegistry = functionContributions.getTypeConfiguration().getBasicTypeRegistry();
        this.registerSDOFunctions();
    }

    @Override
    public Map<FunctionKey, SqmFunctionDescriptor> asMap() {
        return Collections.unmodifiableMap(this.map);
    }

    private void registerSDOFunctions() {
        this.map.put(CommonSpatialFunction.ST_ASTEXT.getKey(), (SqmFunctionDescriptor)new NamedSqmFunctionDescriptor("SDO_UTIL.TO_WKTGEOMETRY", false, StandardArgumentsValidators.exactly((int)1), StandardFunctionReturnTypeResolvers.invariant((BasicType)this.typeRegistry.resolve(StandardBasicTypes.STRING))));
        this.map.put(CommonSpatialFunction.ST_GEOMETRYTYPE.getKey(), (SqmFunctionDescriptor)new SDOGetGeometryType(this.typeRegistry));
        this.map.put(CommonSpatialFunction.ST_DIMENSION.getKey(), (SqmFunctionDescriptor)new SDOMethodDescriptor("Get_Dims", StandardArgumentsValidators.exactly((int)1), StandardFunctionReturnTypeResolvers.invariant((BasicType)this.typeRegistry.resolve(StandardBasicTypes.INTEGER))));
        this.map.put(CommonSpatialFunction.ST_ENVELOPE.getKey(), (SqmFunctionDescriptor)new NamedSqmFunctionDescriptor("SDO_GEOM.SDO_MBR", true, StandardArgumentsValidators.exactly((int)1), StandardFunctionReturnTypeResolvers.useFirstNonNull()));
        this.map.put(CommonSpatialFunction.ST_SRID.getKey(), (SqmFunctionDescriptor)new SDOMethodDescriptor("SDO_SRID", false, StandardArgumentsValidators.exactly((int)1), StandardFunctionReturnTypeResolvers.invariant((BasicType)this.typeRegistry.resolve(StandardBasicTypes.INTEGER))));
        this.map.put(CommonSpatialFunction.ST_ASBINARY.getKey(), (SqmFunctionDescriptor)new SDOMethodDescriptor("Get_WKB", true, StandardArgumentsValidators.exactly((int)1), StandardFunctionReturnTypeResolvers.invariant((BasicType)this.typeRegistry.resolve(StandardBasicTypes.BINARY))));
        this.map.put(CommonSpatialFunction.ST_ISSIMPLE.getKey(), (SqmFunctionDescriptor)new OracleSpatialSQLMMFunction("ST_ISSIMPLE", "ST_ISSIMPLE", 1, StandardFunctionReturnTypeResolvers.invariant((BasicType)this.typeRegistry.resolve(StandardBasicTypes.BOOLEAN)), false));
        this.map.put(CommonSpatialFunction.ST_ISEMPTY.getKey(), (SqmFunctionDescriptor)new OracleSpatialSQLMMFunction("ST_ISEMPTY", "ST_ISEMPTY", 1, StandardFunctionReturnTypeResolvers.invariant((BasicType)this.typeRegistry.resolve(StandardBasicTypes.BOOLEAN)), false));
        this.map.put(CommonSpatialFunction.ST_BOUNDARY.getKey(), (SqmFunctionDescriptor)new OracleSpatialSQLMMFunction("ST_BOUNDARY", "ST_BOUNDARY", 1, StandardFunctionReturnTypeResolvers.useFirstNonNull(), true));
        this.map.put(CommonSpatialFunction.ST_OVERLAPS.getKey(), (SqmFunctionDescriptor)new SDORelateFunction(List.of("CONTAINS"), this.typeRegistry));
        this.map.put(CommonSpatialFunction.ST_CROSSES.getKey(), (SqmFunctionDescriptor)new OracleSpatialSQLMMFunction("ST_CROSSES", "ST_CROSSES", 2, StandardFunctionReturnTypeResolvers.invariant((BasicType)this.typeRegistry.resolve(StandardBasicTypes.BOOLEAN)), false));
        this.map.put(CommonSpatialFunction.ST_INTERSECTS.getKey(), (SqmFunctionDescriptor)new SDORelateFunction(List.of("OVERLAPBDYDISJOINT", "OVERLAPBDYINTERSECT"), this.typeRegistry));
        this.map.put(CommonSpatialFunction.ST_CONTAINS.getKey(), (SqmFunctionDescriptor)new SDORelateFunction(List.of("CONTAINS"), this.typeRegistry));
        this.map.put(CommonSpatialFunction.ST_DISJOINT.getKey(), (SqmFunctionDescriptor)new SDORelateFunction(List.of("DISJOINT"), this.typeRegistry));
        this.map.put(CommonSpatialFunction.ST_RELATE.getKey(), (SqmFunctionDescriptor)new STRelateFunction(this.typeRegistry));
        this.map.put(CommonSpatialFunction.ST_TOUCHES.getKey(), (SqmFunctionDescriptor)new SDORelateFunction(List.of("TOUCH"), this.typeRegistry));
        this.map.put(CommonSpatialFunction.ST_WITHIN.getKey(), (SqmFunctionDescriptor)new SDORelateFunction(List.of("COVERS", "CONTAINS"), this.typeRegistry));
        this.map.put(CommonSpatialFunction.ST_EQUALS.getKey(), (SqmFunctionDescriptor)new SDORelateFunction(List.of("EQUAL"), this.typeRegistry));
        this.map.put(CommonSpatialFunction.ST_DISTANCE.getKey(), (SqmFunctionDescriptor)new NamedSqmFunctionDescriptor("SDO_GEOM.SDO_DISTANCE", true, StandardArgumentsValidators.exactly((int)2), StandardFunctionReturnTypeResolvers.invariant((BasicType)this.typeRegistry.resolve(StandardBasicTypes.DOUBLE))));
        this.map.put(CommonSpatialFunction.ST_BUFFER.getKey(), (SqmFunctionDescriptor)new NamedSqmFunctionDescriptor("SDO_GEOM.SDO_BUFFER", true, StandardArgumentsValidators.exactly((int)2), StandardFunctionReturnTypeResolvers.useFirstNonNull()));
        this.map.put(CommonSpatialFunction.ST_CONVEXHULL.getKey(), (SqmFunctionDescriptor)new NamedSqmFunctionDescriptor("SDO_GEOM.SDO_CONVEXHULL", true, StandardArgumentsValidators.exactly((int)1), StandardFunctionReturnTypeResolvers.useFirstNonNull()));
        this.map.put(CommonSpatialFunction.ST_DIFFERENCE.getKey(), (SqmFunctionDescriptor)new NamedSqmFunctionDescriptor("SDO_GEOM.SDO_DIFFERENCE", true, StandardArgumentsValidators.exactly((int)2), StandardFunctionReturnTypeResolvers.useFirstNonNull()));
        this.map.put(CommonSpatialFunction.ST_INTERSECTION.getKey(), (SqmFunctionDescriptor)new NamedSqmFunctionDescriptor("SDO_GEOM.SDO_INTERSECTION", true, StandardArgumentsValidators.exactly((int)2), StandardFunctionReturnTypeResolvers.useFirstNonNull()));
        this.map.put(CommonSpatialFunction.ST_SYMDIFFERENCE.getKey(), (SqmFunctionDescriptor)new NamedSqmFunctionDescriptor("SDO_GEOM.SDO_XOR", true, StandardArgumentsValidators.exactly((int)2), StandardFunctionReturnTypeResolvers.useFirstNonNull()));
        this.map.put(CommonSpatialFunction.ST_UNION.getKey(), (SqmFunctionDescriptor)new NamedSqmFunctionDescriptor("SDO_GEOM.SDO_UNION", true, StandardArgumentsValidators.exactly((int)2), StandardFunctionReturnTypeResolvers.useFirstNonNull()));
    }
}

