/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial.dialect.h2gis;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.Wkt;
import org.hibernate.spatial.GeometryLiteralFormatter;
import org.hibernate.spatial.dialect.h2gis.H2GISWkb;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;

public class H2GISGeometryType
implements JdbcType {
    public static final H2GISGeometryType INSTANCE = new H2GISGeometryType();

    public int getJdbcTypeCode() {
        return 2003;
    }

    public int getDefaultSqlTypeCode() {
        return 3200;
    }

    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaType) {
        return new GeometryLiteralFormatter<T>(javaType, Wkt.Dialect.SFA_1_1_0, "ST_GeomFromText");
    }

    public <X> ValueBinder<X> getBinder(JavaType<X> javaType) {
        return new BasicBinder<X>(javaType, this){

            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                Geometry geometry = (Geometry)this.getJavaType().unwrap(value, Geometry.class, options);
                st.setBytes(index, H2GISWkb.to(geometry));
            }

            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                Geometry geometry = (Geometry)this.getJavaType().unwrap(value, Geometry.class, options);
                st.setBytes(name, H2GISWkb.to(geometry));
            }
        };
    }

    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaType) {
        return new BasicExtractor<X>(javaType, this){

            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap((Object)H2GISWkb.from(rs.getObject(paramIndex)), options);
            }

            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap((Object)H2GISWkb.from(statement.getObject(index)), options);
            }

            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return this.getJavaType().wrap((Object)H2GISWkb.from(statement.getObject(name)), options);
            }
        };
    }
}

