/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.spatial;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.codec.Wkt;
import org.hibernate.dialect.Dialect;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;

public class GeometryLiteralFormatter<T>
implements JdbcLiteralFormatter<T> {
    protected final JavaType<T> javaType;
    protected final Wkt.Dialect wktDialect;
    protected final String geomFromTextName;

    public GeometryLiteralFormatter(JavaType<T> javaType, Wkt.Dialect wktDialect, String geomFromTextName) {
        this.javaType = javaType;
        this.wktDialect = wktDialect;
        this.geomFromTextName = geomFromTextName;
    }

    public void appendJdbcLiteral(SqlAppender appender, T value, Dialect dialect, WrapperOptions wrapperOptions) {
        Geometry geom = (Geometry)this.javaType.unwrap(value, Geometry.class, wrapperOptions);
        appender.appendSql(this.geomFromTextName);
        appender.appendSql("('");
        appender.appendSql(Wkt.toWkt((Geometry)geom, (Wkt.Dialect)this.wktDialect));
        appender.appendSql("',");
        appender.appendSql(Math.max(geom.getSRID(), 0));
        appender.appendSql(")");
    }
}

