/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.processor.annotation.AbstractQueryMethod;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.annotation.OrderBy;
import org.hibernate.processor.util.StringUtil;

public class QueryMethod
extends AbstractQueryMethod {
    private final @UnknownKeyFor @NonNull @Initialized String queryString;
    private final @Nullable @UnknownKeyFor @Initialized String returnTypeClass;
    private final @Nullable @UnknownKeyFor @Initialized String containerType;
    private final @UnknownKeyFor @NonNull @Initialized boolean isUpdate;
    private final @UnknownKeyFor @NonNull @Initialized boolean isNative;

    QueryMethod(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized String queryString, @Nullable @UnknownKeyFor @Initialized String returnTypeName, @Nullable @UnknownKeyFor @Initialized String returnTypeClass, @Nullable @UnknownKeyFor @Initialized String containerType, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized boolean isUpdate, @UnknownKeyFor @NonNull @Initialized boolean isNative, @UnknownKeyFor @NonNull @Initialized boolean belongsToDao, @UnknownKeyFor @NonNull @Initialized String sessionType, @UnknownKeyFor @NonNull @Initialized String sessionName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized OrderBy> orderBys, @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation, @UnknownKeyFor @NonNull @Initialized boolean dataRepository, @UnknownKeyFor @NonNull @Initialized String fullReturnType, @UnknownKeyFor @NonNull @Initialized boolean nullable) {
        super(annotationMetaEntity, method, methodName, paramNames, paramTypes, returnTypeName, sessionType, sessionName, belongsToDao, orderBys, addNonnullAnnotation, dataRepository, fullReturnType, nullable);
        this.queryString = queryString;
        this.returnTypeClass = returnTypeClass;
        this.containerType = containerType;
        this.isUpdate = isUpdate;
        this.isNative = isNative;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasStringAttribute() {
        return true;
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized boolean isNullable(@UnknownKeyFor @NonNull @Initialized int index) {
        return true;
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized boolean singleResult() {
        return this.containerType == null;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeDeclarationString() {
        List<String> paramTypes = this.parameterTypes();
        StringBuilder declaration = new StringBuilder();
        this.comment(declaration);
        this.modifiers(paramTypes, declaration);
        this.preamble(declaration, paramTypes);
        this.collectOrdering(declaration, paramTypes);
        this.chainSession(declaration);
        this.tryReturn(declaration, paramTypes, this.containerType);
        this.castResult(declaration);
        this.createQuery(declaration);
        this.setParameters(declaration, paramTypes, "");
        this.handlePageParameters(declaration, paramTypes, this.containerType);
        boolean unwrapped = !this.isUsingEntityManager();
        unwrapped = this.applyOrder(declaration, paramTypes, this.containerType, unwrapped);
        this.execute(declaration, unwrapped);
        this.convertExceptions(declaration);
        this.chainSessionEnd(this.isUpdate, declaration);
        QueryMethod.closingBrace(declaration);
        return declaration.toString();
    }

    @Override
    void createQuery(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append(this.localSessionName()).append('.').append(this.createQueryMethod()).append("(").append(this.getConstantName());
        if (this.returnTypeClass != null && !this.isUpdate) {
            declaration.append(", ").append(this.annotationMetaEntity.importType(this.returnTypeClass)).append(".class");
        }
        declaration.append(")\n");
    }

    private @UnknownKeyFor @NonNull @Initialized String createQueryMethod() {
        if (this.isNative) {
            return "createNativeQuery";
        }
        if (this.isUsingEntityManager() || this.isReactive() || QueryMethod.isUnspecializedQueryType(this.containerType)) {
            return "createQuery";
        }
        return this.isUpdate ? "createMutationQuery" : "createSelectionQuery";
    }

    private void castResult(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.isNative && this.returnTypeName != null && this.containerType == null && this.isUsingEntityManager()) {
            declaration.append("(").append(this.fullReturnType).append(") ");
        }
    }

    private void execute(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized boolean unwrapped) {
        if (this.isUpdate) {
            declaration.append("\t\t\t").append(".executeUpdate()");
            if ("boolean".equals(this.returnTypeName)) {
                declaration.append(" > 0");
            }
            declaration.append(";\n");
        } else {
            boolean mustUnwrap = QueryMethod.isHibernateQueryType(this.containerType) || this.isNative && this.returnTypeName != null;
            this.executeSelect(declaration, this.paramTypes, this.containerType, unwrapped, mustUnwrap);
        }
    }

    @Override
    void setParameters(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized String indent) {
        for (int i = 0; i < this.paramNames.size(); ++i) {
            String paramName = (String)this.paramNames.get(i);
            String paramType = paramTypes.get(i);
            if (QueryMethod.isSpecialParam(paramType)) continue;
            int ordinal = i + 1;
            if (this.queryString.contains(":" + paramName)) {
                declaration.append(indent);
                QueryMethod.setNamedParameter(declaration, paramName);
                continue;
            }
            if (!this.queryString.contains("?" + ordinal)) continue;
            declaration.append(indent);
            QueryMethod.setOrdinalParameter(declaration, ordinal, paramName);
        }
    }

    private static void setOrdinalParameter(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized int i, @UnknownKeyFor @NonNull @Initialized String paramName) {
        declaration.append("\t\t\t.setParameter(").append(i).append(", ").append(paramName).append(")\n");
    }

    private static void setNamedParameter(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized String paramName) {
        declaration.append("\t\t\t.setParameter(\"").append(paramName).append("\", ").append(paramName).append(")\n");
    }

    private void comment(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append("\n/**");
        declaration.append("\n * Execute the query {@value #").append(this.getConstantName()).append("}.").append("\n *");
        this.see(declaration);
        declaration.append("\n **/\n");
    }

    private void modifiers(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        boolean hasVarargs = paramTypes.stream().anyMatch(ptype -> ptype.endsWith("..."));
        if (hasVarargs) {
            declaration.append("@SafeVarargs\n");
        }
        if (this.belongsToDao) {
            declaration.append("@Override\npublic ");
            if (hasVarargs) {
                declaration.append("final ");
            }
        } else {
            declaration.append("public static ");
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeNameDeclarationString() {
        StringBuilder sb = new StringBuilder(this.queryString.length() + 100).append("static final String ").append(this.getConstantName()).append(" = \"");
        block6: for (int i = 0; i < this.queryString.length(); ++i) {
            char c = this.queryString.charAt(i);
            switch (c) {
                case '\r': {
                    sb.append("\\r");
                    continue block6;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block6;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block6;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.append("\";").toString();
    }

    private @UnknownKeyFor @NonNull @Initialized String getConstantName() {
        String stem = StringUtil.getUpperUnderscoreCaseFromLowerCamelCase(this.methodName);
        if (this.paramTypes.isEmpty()) {
            return stem;
        }
        return stem + "_" + this.paramTypes.stream().filter(type -> !QueryMethod.isSpecialParam(type)).map(type -> type.indexOf(60) > 0 ? type.substring(0, type.indexOf(60)) : type).map(StringHelper::unqualify).map(type -> type.replace("[]", "Array")).reduce((x, y) -> x + "_" + y).orElse("");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTypeDeclaration() {
        return "jakarta.persistence.Query";
    }
}

