/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.id;

import java.util.Map;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.id.AbstractIdMapper;
import org.hibernate.envers.internal.entities.mapper.id.SimpleIdMapperBuilder;
import org.hibernate.envers.internal.entities.mapper.id.SingleIdMapper;
import org.hibernate.envers.internal.tools.Tools;
import org.hibernate.mapping.Component;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.type.spi.CompositeTypeImplementor;

public abstract class AbstractCompositeIdMapper
extends AbstractIdMapper
implements SimpleIdMapperBuilder {
    protected final CompositeTypeImplementor compositeType;
    protected Map<PropertyData, AbstractIdMapper> ids;

    protected AbstractCompositeIdMapper(Component component) {
        this(component.getServiceRegistry(), (CompositeTypeImplementor)component.getType());
    }

    protected AbstractCompositeIdMapper(ServiceRegistry serviceRegistry, CompositeTypeImplementor compositeType) {
        super(serviceRegistry);
        this.compositeType = compositeType;
        this.ids = Tools.newLinkedHashMap();
    }

    @Override
    public void add(PropertyData propertyData) {
        this.add(propertyData, new SingleIdMapper(this.getServiceRegistry(), propertyData));
    }

    @Override
    public void add(PropertyData propertyData, AbstractIdMapper idMapper) {
        this.ids.put(propertyData, idMapper);
    }

    @Override
    public Object mapToIdFromMap(Map data) {
        if (data == null) {
            return null;
        }
        if (!this.compositeType.isMutable()) {
            return this.mapToImmutableIdFromMap(data);
        }
        Object compositeId = this.instantiateCompositeId(null);
        if (this.compositeType.isMutable()) {
            for (AbstractIdMapper mapper : this.ids.values()) {
                if (mapper.mapToEntityFromMap(compositeId, data)) continue;
                return null;
            }
        }
        return compositeId;
    }

    protected Object mapToImmutableIdFromMap(Map data) {
        String[] propertyNames = this.compositeType.getPropertyNames();
        Object[] values = new Object[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            values[i] = data.get(propertyNames[i]);
        }
        return this.instantiateCompositeId(values);
    }

    @Override
    public void mapToEntityFromEntity(Object objectTo, Object objectFrom) {
    }

    protected Object instantiateCompositeId(Object[] values) {
        try {
            return this.compositeType.getMappingModelPart().getEmbeddableTypeDescriptor().getRepresentationStrategy().getInstantiator().instantiate(() -> values);
        }
        catch (Exception e) {
            throw new AuditException(e);
        }
    }
}

