/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpamodelgen.annotation;

import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.tools.Diagnostic;
import org.hibernate.jpamodelgen.Context;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaAttribute;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaCollection;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaEntity;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaMap;
import org.hibernate.jpamodelgen.annotation.AnnotationMetaSingleAttribute;
import org.hibernate.jpamodelgen.annotation.BasicAttributeVisitor;
import org.hibernate.jpamodelgen.util.AccessType;
import org.hibernate.jpamodelgen.util.AccessTypeInformation;
import org.hibernate.jpamodelgen.util.Constants;
import org.hibernate.jpamodelgen.util.StringUtil;
import org.hibernate.jpamodelgen.util.TypeUtils;

public class MetaAttributeGenerationVisitor
extends SimpleTypeVisitor6<AnnotationMetaAttribute, Element> {
    private static final String ORG_HIBERNATE_ANNOTATIONS_TARGET = "org.hibernate.annotations.Target";
    private static final String ORG_HIBERNATE_ANNOTATIONS_TYPE = "org.hibernate.annotations.Type";
    private final AnnotationMetaEntity entity;
    private final Context context;

    MetaAttributeGenerationVisitor(AnnotationMetaEntity entity, Context context) {
        this.entity = entity;
        this.context = context;
    }

    @Override
    public AnnotationMetaAttribute visitPrimitive(PrimitiveType t, Element element) {
        return new AnnotationMetaSingleAttribute(this.entity, element, TypeUtils.toTypeString(t));
    }

    @Override
    public AnnotationMetaAttribute visitArray(ArrayType t, Element element) {
        return new AnnotationMetaSingleAttribute(this.entity, element, TypeUtils.toTypeString(t));
    }

    @Override
    public AnnotationMetaAttribute visitTypeVariable(TypeVariable t, Element element) {
        TypeMirror mirror = t.getUpperBound();
        TypeMirror erasedType = this.context.getTypeUtils().erasure(mirror);
        return new AnnotationMetaSingleAttribute(this.entity, element, erasedType.toString());
    }

    @Override
    public AnnotationMetaAttribute visitDeclared(DeclaredType declaredType, Element element) {
        AnnotationMetaAttribute metaAttribute = null;
        TypeElement returnedElement = (TypeElement)this.context.getTypeUtils().asElement(declaredType);
        String fqNameOfReturnType = returnedElement.getQualifiedName().toString();
        String collection = Constants.COLLECTIONS.get(fqNameOfReturnType);
        String targetEntity = this.getTargetEntity(element.getAnnotationMirrors());
        if (collection != null) {
            return this.createMetaCollectionAttribute(declaredType, element, fqNameOfReturnType, collection, targetEntity);
        }
        if (this.isBasicAttribute(element, returnedElement)) {
            String type = targetEntity != null ? targetEntity : returnedElement.getQualifiedName().toString();
            return new AnnotationMetaSingleAttribute(this.entity, element, type);
        }
        return metaAttribute;
    }

    private AnnotationMetaAttribute createMetaCollectionAttribute(DeclaredType declaredType, Element element, String fqNameOfReturnType, String collection, String targetEntity) {
        if (TypeUtils.containsAnnotation(element, "javax.persistence.ElementCollection")) {
            String explicitTargetEntity = this.getTargetEntity(element.getAnnotationMirrors());
            TypeMirror collectionElementType = TypeUtils.getCollectionElementType(declaredType, fqNameOfReturnType, explicitTargetEntity, this.context);
            TypeElement collectionElement = (TypeElement)this.context.getTypeUtils().asElement(collectionElementType);
            AccessTypeInformation accessTypeInfo = this.context.getAccessTypeInfo(collectionElementType.toString());
            if (accessTypeInfo == null) {
                AccessType explicitAccessType = null;
                if (collectionElement != null) {
                    explicitAccessType = TypeUtils.determineAnnotationSpecifiedAccessType(collectionElement);
                }
                accessTypeInfo = new AccessTypeInformation(collectionElementType.toString(), explicitAccessType, this.entity.getEntityAccessTypeInfo().getAccessType());
                this.context.addAccessTypeInformation(collectionElementType.toString(), accessTypeInfo);
            } else {
                accessTypeInfo.setDefaultAccessType(this.entity.getEntityAccessTypeInfo().getAccessType());
            }
        }
        if (TypeUtils.containsAnnotation(element, "javax.persistence.Convert") || TypeUtils.containsAnnotation(element, ORG_HIBERNATE_ANNOTATIONS_TYPE)) {
            return new AnnotationMetaSingleAttribute(this.entity, element, TypeUtils.toTypeString(declaredType));
        }
        if (collection.equals("javax.persistence.metamodel.MapAttribute")) {
            return this.createAnnotationMetaAttributeForMap(declaredType, element, collection, targetEntity);
        }
        return new AnnotationMetaCollection(this.entity, element, collection, this.getElementType(declaredType, targetEntity));
    }

    @Override
    public AnnotationMetaAttribute visitExecutable(ExecutableType t, Element p) {
        if (!p.getKind().equals((Object)ElementKind.METHOD)) {
            return null;
        }
        String string = p.getSimpleName().toString();
        if (!StringUtil.isProperty(string, TypeUtils.toTypeString(t.getReturnType()))) {
            return null;
        }
        TypeMirror returnType = t.getReturnType();
        return returnType.accept(this, p);
    }

    private boolean isBasicAttribute(Element element, Element returnedElement) {
        if (TypeUtils.containsAnnotation(element, "javax.persistence.Basic") || TypeUtils.containsAnnotation(element, "javax.persistence.OneToOne") || TypeUtils.containsAnnotation(element, "javax.persistence.ManyToOne") || TypeUtils.containsAnnotation(element, "javax.persistence.EmbeddedId") || TypeUtils.containsAnnotation(element, "javax.persistence.Id")) {
            return true;
        }
        if (TypeUtils.getAnnotationMirror(element, ORG_HIBERNATE_ANNOTATIONS_TYPE) != null) {
            return true;
        }
        BasicAttributeVisitor basicVisitor = new BasicAttributeVisitor(this.context);
        return returnedElement.asType().accept(basicVisitor, returnedElement);
    }

    private AnnotationMetaAttribute createAnnotationMetaAttributeForMap(DeclaredType declaredType, Element element, String collection, String targetEntity) {
        String keyType;
        if (TypeUtils.containsAnnotation(element, "javax.persistence.MapKeyClass")) {
            TypeMirror typeMirror = (TypeMirror)TypeUtils.getAnnotationValue(TypeUtils.getAnnotationMirror(element, "javax.persistence.MapKeyClass"), "value");
            keyType = typeMirror.toString();
        } else {
            keyType = TypeUtils.getKeyType(declaredType, this.context);
        }
        return new AnnotationMetaMap(this.entity, element, collection, keyType, this.getElementType(declaredType, targetEntity));
    }

    private String getElementType(DeclaredType declaredType, String targetEntity) {
        if (targetEntity != null) {
            return targetEntity;
        }
        List<? extends TypeMirror> mirrors = declaredType.getTypeArguments();
        if (mirrors.size() == 1) {
            TypeMirror type = mirrors.get(0);
            return TypeUtils.extractClosestRealTypeAsString(type, this.context);
        }
        if (mirrors.size() == 2) {
            return TypeUtils.extractClosestRealTypeAsString(mirrors.get(1), this.context);
        }
        if (mirrors.size() > 2) {
            this.context.logMessage(Diagnostic.Kind.WARNING, "Unable to find the closest solid type" + declaredType);
        }
        return "?";
    }

    private String getTargetEntity(List<? extends AnnotationMirror> annotations) {
        String fullyQualifiedTargetEntityName = null;
        for (AnnotationMirror annotationMirror : annotations) {
            if (TypeUtils.isAnnotationMirrorOfType(annotationMirror, "javax.persistence.ElementCollection")) {
                fullyQualifiedTargetEntityName = this.getFullyQualifiedClassNameOfTargetEntity(annotationMirror, "targetClass");
                continue;
            }
            if (TypeUtils.isAnnotationMirrorOfType(annotationMirror, "javax.persistence.OneToMany") || TypeUtils.isAnnotationMirrorOfType(annotationMirror, "javax.persistence.ManyToMany") || TypeUtils.isAnnotationMirrorOfType(annotationMirror, "javax.persistence.ManyToOne") || TypeUtils.isAnnotationMirrorOfType(annotationMirror, "javax.persistence.OneToOne")) {
                fullyQualifiedTargetEntityName = this.getFullyQualifiedClassNameOfTargetEntity(annotationMirror, "targetEntity");
                continue;
            }
            if (!TypeUtils.isAnnotationMirrorOfType(annotationMirror, ORG_HIBERNATE_ANNOTATIONS_TARGET)) continue;
            fullyQualifiedTargetEntityName = this.getFullyQualifiedClassNameOfTargetEntity(annotationMirror, "value");
        }
        return fullyQualifiedTargetEntityName;
    }

    private String getFullyQualifiedClassNameOfTargetEntity(AnnotationMirror mirror, String parameterName) {
        TypeMirror parameterType;
        assert (mirror != null);
        assert (parameterName != null);
        String targetEntityName = null;
        Object parameterValue = TypeUtils.getAnnotationValue(mirror, parameterName);
        if (parameterValue != null && !(parameterType = (TypeMirror)parameterValue).getKind().equals((Object)TypeKind.VOID)) {
            targetEntityName = parameterType.toString();
        }
        return targetEntityName;
    }
}

