/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.tools.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.envers.RevisionType;
import org.hibernate.envers.internal.entities.RevisionTypeType;
import org.hibernate.envers.internal.tools.MutableInteger;
import org.hibernate.envers.internal.tools.StringTools;
import org.hibernate.envers.internal.tools.Triple;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.type.CustomType;
import org.hibernate.type.Type;
import org.hibernate.usertype.UserType;

public class QueryBuilder {
    private final String entityName;
    private final String alias;
    private final MutableInteger aliasCounter;
    private final MutableInteger paramCounter;
    private final List<Parameters> parameters = new ArrayList<Parameters>();
    private final List<Triple<String, String, Boolean>> froms;
    private final List<Triple<String, String, Boolean>> orders;
    private final List<String> projections;

    public QueryBuilder(String entityName, String alias) {
        this(entityName, alias, new MutableInteger(), new MutableInteger());
    }

    private QueryBuilder(String entityName, String alias, MutableInteger aliasCounter, MutableInteger paramCounter) {
        this.entityName = entityName;
        this.alias = alias;
        this.aliasCounter = aliasCounter;
        this.paramCounter = paramCounter;
        Parameters rootParameters = new Parameters(alias, "and", paramCounter);
        this.parameters.add(rootParameters);
        this.froms = new ArrayList<Triple<String, String, Boolean>>();
        this.orders = new ArrayList<Triple<String, String, Boolean>>();
        this.projections = new ArrayList<String>();
        this.addFrom(entityName, alias, true);
    }

    private QueryBuilder(QueryBuilder other) {
        this.entityName = other.entityName;
        this.alias = other.alias;
        this.aliasCounter = other.aliasCounter.deepCopy();
        this.paramCounter = other.paramCounter.deepCopy();
        for (Parameters params : other.parameters) {
            this.parameters.add(params.deepCopy());
        }
        this.froms = new ArrayList<Triple<String, String, Boolean>>(other.froms);
        this.orders = new ArrayList<Triple<String, String, Boolean>>(other.orders);
        this.projections = new ArrayList<String>(other.projections);
    }

    public QueryBuilder deepCopy() {
        return new QueryBuilder(this);
    }

    public String getAlias() {
        return this.alias;
    }

    public void addFrom(String entityName, String alias, boolean select) {
        this.froms.add(Triple.make(entityName, alias, select));
    }

    public String generateAlias() {
        return "_e" + this.aliasCounter.getAndIncrease();
    }

    public QueryBuilder newSubQueryBuilder() {
        return this.newSubQueryBuilder(this.entityName, this.generateAlias());
    }

    public QueryBuilder newSubQueryBuilder(String entityName, String alias) {
        return new QueryBuilder(entityName, alias, this.aliasCounter, this.paramCounter);
    }

    public Parameters getRootParameters() {
        return this.parameters.get(0);
    }

    public Parameters addParameters(String alias) {
        Parameters result = new Parameters(alias, "and", this.paramCounter);
        this.parameters.add(result);
        return result;
    }

    public void addOrder(String alias, String propertyName, boolean ascending) {
        this.orders.add(Triple.make(alias, propertyName, ascending));
    }

    public void addProjection(String function, String alias, String propertyName, boolean distinct) {
        String effectivePropertyName;
        String string = effectivePropertyName = propertyName == null ? "" : ".".concat(propertyName);
        if (function == null) {
            this.projections.add((distinct ? "distinct " : "") + alias + effectivePropertyName);
        } else {
            this.projections.add(function + "(" + (distinct ? "distinct " : "") + alias + effectivePropertyName + ")");
        }
    }

    public void build(StringBuilder sb, Map<String, Object> queryParamValues) {
        sb.append("select ");
        if (this.projections.size() > 0) {
            StringTools.append(sb, this.projections.iterator(), ", ");
        } else {
            StringTools.append(sb, this.getSelectAliasList().iterator(), ", ");
        }
        sb.append(" from ");
        StringTools.append(sb, this.getFromList().iterator(), ", ");
        boolean first = true;
        for (Parameters params : this.parameters) {
            if (params.isEmpty()) continue;
            if (first) {
                sb.append(" where ");
                first = false;
            } else {
                sb.append(" and ");
            }
            params.build(sb, queryParamValues);
        }
        if (this.orders.size() > 0) {
            sb.append(" order by ");
            StringTools.append(sb, this.getOrderList().iterator(), ", ");
        }
    }

    private List<String> getSelectAliasList() {
        ArrayList<String> aliasList = new ArrayList<String>();
        for (Triple<String, String, Boolean> from : this.froms) {
            if (!from.getThird().booleanValue()) continue;
            aliasList.add(from.getSecond());
        }
        return aliasList;
    }

    public String getRootAlias() {
        return this.alias;
    }

    private List<String> getFromList() {
        ArrayList<String> fromList = new ArrayList<String>();
        for (Triple<String, String, Boolean> from : this.froms) {
            fromList.add(from.getFirst() + " " + from.getSecond());
        }
        return fromList;
    }

    private List<String> getOrderList() {
        ArrayList<String> orderList = new ArrayList<String>();
        for (Triple<String, String, Boolean> order : this.orders) {
            orderList.add(order.getFirst() + "." + order.getSecond() + " " + (order.getThird() != false ? "asc" : "desc"));
        }
        return orderList;
    }

    public Query toQuery(Session session) {
        StringBuilder querySb = new StringBuilder();
        HashMap<String, Object> queryParamValues = new HashMap<String, Object>();
        this.build(querySb, queryParamValues);
        Query query = session.createQuery(querySb.toString());
        for (Map.Entry paramValue : queryParamValues.entrySet()) {
            if (paramValue.getValue() instanceof RevisionType) {
                query.setParameter((String)paramValue.getKey(), paramValue.getValue(), (Type)new CustomType((UserType)new RevisionTypeType()));
                continue;
            }
            query.setParameter((String)paramValue.getKey(), paramValue.getValue());
        }
        return query;
    }
}

