/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.tools.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.envers.internal.tools.MutableBoolean;
import org.hibernate.envers.internal.tools.MutableInteger;
import org.hibernate.envers.internal.tools.query.QueryBuilder;

public class Parameters {
    public static final String AND = "and";
    public static final String OR = "or";
    private final String alias;
    private final String connective;
    private final MutableInteger queryParamCounter;
    private final List<Parameters> subParameters;
    private final List<Parameters> negatedParameters;
    private final List<String> expressions;
    private final Map<String, Object> localQueryParamValues;

    Parameters(String alias, String connective, MutableInteger queryParamCounter) {
        this.alias = alias;
        this.connective = connective;
        this.queryParamCounter = queryParamCounter;
        this.subParameters = new ArrayList<Parameters>();
        this.negatedParameters = new ArrayList<Parameters>();
        this.expressions = new ArrayList<String>();
        this.localQueryParamValues = new HashMap<String, Object>();
    }

    private Parameters(Parameters other) {
        this.alias = other.alias;
        this.connective = other.connective;
        this.queryParamCounter = other.queryParamCounter.deepCopy();
        this.subParameters = new ArrayList<Parameters>(other.subParameters.size());
        for (Parameters p : other.subParameters) {
            this.subParameters.add(p.deepCopy());
        }
        this.negatedParameters = new ArrayList<Parameters>(other.negatedParameters.size());
        for (Parameters p : other.negatedParameters) {
            this.negatedParameters.add(p.deepCopy());
        }
        this.expressions = new ArrayList<String>(other.expressions);
        this.localQueryParamValues = new HashMap<String, Object>(other.localQueryParamValues);
    }

    public Parameters deepCopy() {
        return new Parameters(this);
    }

    private String generateQueryParam() {
        return "_p" + this.queryParamCounter.getAndIncrease();
    }

    public Parameters addSubParameters(String newConnective) {
        if (this.connective.equals(newConnective)) {
            return this;
        }
        Parameters newParams = new Parameters(this.alias, newConnective, this.queryParamCounter);
        this.subParameters.add(newParams);
        return newParams;
    }

    public Parameters addNegatedParameters() {
        Parameters newParams = new Parameters(this.alias, AND, this.queryParamCounter);
        this.negatedParameters.add(newParams);
        return newParams;
    }

    public void addWhere(String left, String op, String right) {
        this.addWhere(left, true, op, right, true);
    }

    public void addNullRestriction(String propertyName, boolean addAlias) {
        this.addWhere(propertyName, addAlias, "is", "null", false);
    }

    public void addNotNullRestriction(String propertyName, boolean addAlias) {
        this.addWhere(propertyName, addAlias, "is not", "null", false);
    }

    public void addWhere(String left, boolean addAliasLeft, String op, String right, boolean addAliasRight) {
        StringBuilder expression = new StringBuilder();
        if (addAliasLeft) {
            expression.append(this.alias).append(".");
        }
        expression.append(left);
        expression.append(" ").append(op).append(" ");
        if (addAliasRight) {
            expression.append(this.alias).append(".");
        }
        expression.append(right);
        this.expressions.add(expression.toString());
    }

    public void addWhere(String aliasLeft, String left, String op, String aliasRight, String right) {
        StringBuilder expression = new StringBuilder();
        expression.append(aliasLeft).append('.').append(left);
        expression.append(' ').append(op).append(' ');
        expression.append(aliasRight).append('.').append(right);
        this.expressions.add(expression.toString());
    }

    public void addWhereWithFunction(String left, String leftFunction, String op, Object paramValue) {
        String paramName = this.generateQueryParam();
        this.localQueryParamValues.put(paramName, paramValue);
        StringBuilder expression = new StringBuilder();
        expression.append(leftFunction).append("(");
        expression.append(this.alias).append(".");
        expression.append(left).append(")");
        expression.append(" ").append(op).append(" ");
        expression.append(":").append(paramName);
        this.expressions.add(expression.toString());
    }

    public void addWhereWithParam(String left, String op, Object paramValue) {
        this.addWhereWithParam(left, true, op, paramValue);
    }

    public void addWhereWithParam(String left, boolean addAlias, String op, Object paramValue) {
        String paramName = this.generateQueryParam();
        this.localQueryParamValues.put(paramName, paramValue);
        this.addWhereWithNamedParam(left, addAlias, op, paramName);
    }

    public void addWhereWithNamedParam(String left, String op, String paramName) {
        this.addWhereWithNamedParam(left, true, op, paramName);
    }

    public void addWhereWithNamedParam(String left, boolean addAlias, String op, String paramName) {
        StringBuilder expression = new StringBuilder();
        if (addAlias) {
            expression.append(this.alias).append(".");
        }
        expression.append(left);
        expression.append(" ").append(op).append(" ");
        expression.append(":").append(paramName);
        this.expressions.add(expression.toString());
    }

    public void addWhereWithParams(String left, String opStart, Object[] paramValues, String opEnd) {
        StringBuilder expression = new StringBuilder();
        expression.append(this.alias).append(".").append(left).append(" ").append(opStart);
        for (int i = 0; i < paramValues.length; ++i) {
            Object paramValue = paramValues[i];
            String paramName = this.generateQueryParam();
            this.localQueryParamValues.put(paramName, paramValue);
            expression.append(":").append(paramName);
            if (i == paramValues.length - 1) continue;
            expression.append(", ");
        }
        expression.append(opEnd);
        this.expressions.add(expression.toString());
    }

    public void addWhere(String left, String op, QueryBuilder right) {
        this.addWhere(left, true, op, right);
    }

    public void addWhere(String left, boolean addAlias, String op, QueryBuilder right) {
        StringBuilder expression = new StringBuilder();
        if (addAlias) {
            expression.append(this.alias).append(".");
        }
        expression.append(left);
        expression.append(" ").append(op).append(" ");
        expression.append("(");
        right.build(expression, this.localQueryParamValues);
        expression.append(")");
        this.expressions.add(expression.toString());
    }

    private void append(StringBuilder sb, String toAppend, MutableBoolean isFirst) {
        if (!isFirst.isSet()) {
            sb.append(" ").append(this.connective).append(" ");
        }
        sb.append(toAppend);
        isFirst.unset();
    }

    boolean isEmpty() {
        return this.expressions.size() == 0 && this.subParameters.size() == 0 && this.negatedParameters.size() == 0;
    }

    void build(StringBuilder sb, Map<String, Object> queryParamValues) {
        MutableBoolean isFirst = new MutableBoolean(true);
        for (String expression : this.expressions) {
            this.append(sb, expression, isFirst);
        }
        for (Parameters sub : this.subParameters) {
            if (this.subParameters.isEmpty()) continue;
            this.append(sb, "(", isFirst);
            sub.build(sb, queryParamValues);
            sb.append(")");
        }
        for (Parameters negated : this.negatedParameters) {
            if (this.negatedParameters.isEmpty()) continue;
            this.append(sb, "not (", isFirst);
            negated.build(sb, queryParamValues);
            sb.append(")");
        }
        queryParamValues.putAll(this.localQueryParamValues);
    }
}

