/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.internal.entities.mapper.relation;

import java.io.Serializable;
import java.util.Map;
import javax.persistence.NoResultException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.envers.configuration.spi.AuditConfiguration;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.PropertyData;
import org.hibernate.envers.internal.entities.mapper.relation.AbstractToOneMapper;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;

public abstract class AbstractOneToOneMapper
extends AbstractToOneMapper {
    private final String entityName;
    private final String referencedEntityName;

    protected AbstractOneToOneMapper(String entityName, String referencedEntityName, PropertyData propertyData) {
        super(propertyData);
        this.entityName = entityName;
        this.referencedEntityName = referencedEntityName;
    }

    @Override
    public void nullSafeMapToEntityFromMap(AuditConfiguration verCfg, Object obj, Map data, Object primaryKey, AuditReaderImplementor versionsReader, Number revision) {
        Object value;
        AbstractToOneMapper.EntityInfo referencedEntity = this.getEntityInfo(verCfg, this.referencedEntityName);
        try {
            value = this.queryForReferencedEntity(versionsReader, referencedEntity, (Serializable)primaryKey, revision);
        }
        catch (NoResultException e) {
            value = null;
        }
        catch (NonUniqueResultException e) {
            throw new AuditException("Many versions results for one-to-one relationship " + this.entityName + "." + this.getPropertyData().getBeanName() + ".", e);
        }
        this.setPropertyValue(obj, value);
    }

    protected abstract Object queryForReferencedEntity(AuditReaderImplementor var1, AbstractToOneMapper.EntityInfo var2, Serializable var3, Number var4);

    @Override
    public void mapModifiedFlagsToMapFromEntity(SessionImplementor session, Map<String, Object> data, Object newObj, Object oldObj) {
    }

    @Override
    public void mapModifiedFlagsToMapForCollectionChange(String collectionPropertyName, Map<String, Object> data) {
        if (this.getPropertyData().isUsingModifiedFlag()) {
            data.put(this.getPropertyData().getModifiedFlagPropertyName(), collectionPropertyName.equals(this.getPropertyData().getName()));
        }
    }
}

