/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.convert.internal;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.metamodel.model.convert.spi.EnumValueConverter;
import org.hibernate.type.descriptor.java.EnumJavaTypeDescriptor;
import org.jboss.logging.Logger;

public class OrdinalEnumValueConverter<E extends Enum>
implements EnumValueConverter<E, Integer>,
Serializable {
    private static final Logger log = Logger.getLogger(OrdinalEnumValueConverter.class);
    private final EnumJavaTypeDescriptor<E> enumJavaDescriptor;

    public OrdinalEnumValueConverter(EnumJavaTypeDescriptor<E> enumJavaDescriptor) {
        this.enumJavaDescriptor = enumJavaDescriptor;
    }

    @Override
    public E toDomainValue(Integer relationalForm) {
        return this.enumJavaDescriptor.fromOrdinal(relationalForm);
    }

    @Override
    public Integer toRelationalValue(E domainForm) {
        return this.enumJavaDescriptor.toOrdinal(domainForm);
    }

    @Override
    public int getJdbcTypeCode() {
        return 4;
    }

    @Override
    public EnumJavaTypeDescriptor<E> getJavaDescriptor() {
        return this.enumJavaDescriptor;
    }

    @Override
    public E readValue(ResultSet resultSet, String name) throws SQLException {
        int ordinal = resultSet.getInt(name);
        boolean traceEnabled = log.isTraceEnabled();
        if (resultSet.wasNull()) {
            if (traceEnabled) {
                log.trace((Object)String.format("Returning null as column [%s]", name));
            }
            return null;
        }
        E enumValue = this.toDomainValue(ordinal);
        if (traceEnabled) {
            log.trace((Object)String.format("Returning [%s] as column [%s]", enumValue, name));
        }
        return enumValue;
    }

    @Override
    public void writeValue(PreparedStatement statement, E value, int position) throws SQLException {
        Integer jdbcValue = value == null ? null : this.toRelationalValue(value);
        boolean traceEnabled = log.isTraceEnabled();
        if (jdbcValue == null) {
            if (traceEnabled) {
                log.tracef("Binding null to parameter: [%s]", position);
            }
            statement.setNull(position, this.getJdbcTypeCode());
            return;
        }
        if (traceEnabled) {
            log.tracef("Binding [%s] to parameter: [%s]", jdbcValue.intValue(), position);
        }
        statement.setInt(position, jdbcValue);
    }

    @Override
    public String toSqlLiteral(Object value) {
        return Integer.toString(((Enum)value).ordinal());
    }
}

