/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.bytebuddy;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.hibernate.proxy.ProxyConfiguration;

public class PassThroughInterceptor
implements ProxyConfiguration.Interceptor {
    private HashMap data = new HashMap();
    private final Object proxiedObject;
    private final String proxiedClassName;

    public PassThroughInterceptor(Object proxiedObject, String proxiedClassName) {
        this.proxiedObject = proxiedObject;
        this.proxiedClassName = proxiedClassName;
    }

    @Override
    public Object intercept(Object instance, Method method, Object[] arguments) throws Exception {
        boolean hasSetterSignature;
        String name = method.getName();
        if ("toString".equals(name)) {
            return this.proxiedClassName + "@" + System.identityHashCode(instance);
        }
        if ("equals".equals(name)) {
            return this.proxiedObject == instance;
        }
        if ("hashCode".equals(name)) {
            return System.identityHashCode(instance);
        }
        boolean hasGetterSignature = method.getParameterCount() == 0 && method.getReturnType() != null;
        boolean bl = hasSetterSignature = method.getParameterCount() == 1 && (method.getReturnType() == null || method.getReturnType() == Void.TYPE);
        if (name.startsWith("get") && hasGetterSignature) {
            String propName = name.substring(3);
            return this.data.get(propName);
        }
        if (name.startsWith("is") && hasGetterSignature) {
            String propName = name.substring(2);
            return this.data.get(propName);
        }
        if (name.startsWith("set") && hasSetterSignature) {
            String propName = name.substring(3);
            this.data.put(propName, arguments[0]);
            return null;
        }
        return null;
    }
}

