/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.annotations.common.test.reflection.java.generics;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import junit.framework.TestCase;
import org.hibernate.annotations.common.reflection.java.generics.TypeEnvironment;
import org.hibernate.annotations.common.reflection.java.generics.TypeEnvironmentFactory;
import org.hibernate.annotations.common.test.reflection.java.generics.BigBlob;
import org.hibernate.annotations.common.test.reflection.java.generics.SonOfBlob;

public class ApproximatingTypeEnvironmentTest
extends TestCase {
    TypeEnvironmentFactory teFactory = new TypeEnvironmentFactory();
    TypeEnvironment unboundContext = this.teFactory.getEnvironment(BigBlob.class);
    TypeEnvironment approximatingUnboundContext = this.teFactory.toApproximatingEnvironment(this.unboundContext);
    TypeEnvironment boundContext = this.teFactory.getEnvironment(SonOfBlob.class);
    TypeEnvironment approximatingBoundContext = this.teFactory.toApproximatingEnvironment(this.boundContext);

    public void testDoesNothingOnClasses() throws SecurityException {
        ApproximatingTypeEnvironmentTest.assertEquals(String[].class, (Object)this.approximatingUnboundContext.bind(String[].class));
    }

    public void testDoesNothingOnWildcards() throws Exception {
        Type type = BigBlob.class.getMethod("genericClass", new Class[0]).getGenericReturnType();
        Type approxType = this.approximatingBoundContext.bind(type);
        ApproximatingTypeEnvironmentTest.assertEquals((String)"java.lang.Class<?>", (String)approxType.toString());
    }

    public void testDoesNothingOnParameterizedTypesThatAreAlreadyFullyBound() throws Exception {
        Type type = BigBlob.class.getMethod("simpleGenericType", new Class[0]).getGenericReturnType();
        ApproximatingTypeEnvironmentTest.assertEquals((Object)this.boundContext.bind(type), (Object)this.approximatingBoundContext.bind(type));
    }

    public void testDoesNothingOnComplexParameterizedTypesThatAreNotCollections() throws Exception {
        Type type = BigBlob.class.getMethod("genericType", new Class[0]).getGenericReturnType();
        ApproximatingTypeEnvironmentTest.assertEquals((Object)this.boundContext.bind(type), (Object)this.approximatingBoundContext.bind(type));
    }

    public void testDoesNothingOnGenericArraysThatAreAlreadyFullyBound() throws Exception {
        Type type = BigBlob.class.getMethod("array", new Class[0]).getGenericReturnType();
        ApproximatingTypeEnvironmentTest.assertEquals((Object)this.boundContext.bind(type), (Object)this.approximatingBoundContext.bind(type));
    }

    public void testApproximatesSimpleGenericTypesToTheirUpperBound() throws Exception {
        Type type = BigBlob.class.getMethod("simpleGenericType", new Class[0]).getGenericReturnType();
        ApproximatingTypeEnvironmentTest.assertEquals((String)"java.util.List<java.lang.String>", (String)this.approximatingBoundContext.bind(type).toString());
    }

    public void testApproximatesGenericsInArraysToTheirUpperBounds() throws Exception {
        Type type = BigBlob.class.getMethod("array", new Class[0]).getGenericReturnType();
        ApproximatingTypeEnvironmentTest.assertEquals(Collection[].class, (Object)this.approximatingUnboundContext.bind(type));
    }

    public void testApproximatesArraysOfComplexTypesToArraysOfObjects() throws Exception {
        Type type = BigBlob.class.getMethod("complexGenericArray", new Class[0]).getGenericReturnType();
        ApproximatingTypeEnvironmentTest.assertEquals(Object[].class, (Object)this.approximatingUnboundContext.bind(type));
    }

    public void testApproximatesGenericsAndWildcardsInCollectionsToTheirUpperBounds() throws Exception {
        Type type = BigBlob.class.getMethod("genericCollection", new Class[0]).getGenericReturnType();
        ParameterizedType approxType = (ParameterizedType)this.approximatingUnboundContext.bind(type);
        ApproximatingTypeEnvironmentTest.assertEquals(Map.class, (Object)approxType.getRawType());
        ApproximatingTypeEnvironmentTest.assertNull((Object)approxType.getOwnerType());
        ApproximatingTypeEnvironmentTest.assertEquals((int)2, (int)approxType.getActualTypeArguments().length);
        ApproximatingTypeEnvironmentTest.assertEquals(Object.class, (Object)approxType.getActualTypeArguments()[0]);
        ApproximatingTypeEnvironmentTest.assertEquals(Collection.class, (Object)approxType.getActualTypeArguments()[1]);
    }
}

