/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "am" locale.
 */
public class LocalizedNamesImpl_am extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "ET",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "XA",
        "XB",
        "HU",
        "HT",
        "IN",
        "HN",
        "HK",
        "LU",
        "LY",
        "LB",
        "LT",
        "LI",
        "LV",
        "LA",
        "LR",
        "LS",
        "MK",
        "FM",
        "ML",
        "MW",
        "MY",
        "MT",
        "MV",
        "MH",
        "MQ",
        "MO",
        "MM",
        "MG",
        "MX",
        "YT",
        "EH",
        "MD",
        "MU",
        "MR",
        "MA",
        "MC",
        "ME",
        "MS",
        "MN",
        "MZ",
        "RU",
        "RW",
        "RE",
        "RO",
        "SB",
        "KP",
        "RS",
        "SO",
        "SR",
        "SZ",
        "SD",
        "LK",
        "SY",
        "SC",
        "SX",
        "SG",
        "WS",
        "SM",
        "ST",
        "SA",
        "CY",
        "SL",
        "SN",
        "SH",
        "LC",
        "MF",
        "EA",
        "SK",
        "SI",
        "SJ",
        "CH",
        "SE",
        "ES",
        "BL",
        "VC",
        "KN",
        "PM",
        "BZ",
        "BT",
        "BG",
        "BF",
        "BV",
        "BS",
        "BH",
        "BB",
        "BD",
        "BY",
        "BE",
        "BM",
        "BJ",
        "BN",
        "BI",
        "BR",
        "BO",
        "BA",
        "BW",
        "VA",
        "VU",
        "VN",
        "VE",
        "TR",
        "TM",
        "TV",
        "TN",
        "TL",
        "TZ",
        "TH",
        "TW",
        "TJ",
        "TA",
        "TT",
        "TO",
        "TK",
        "TG",
        "CL",
        "CN",
        "TD",
        "CZ",
        "NU",
        "NI",
        "NC",
        "NZ",
        "NE",
        "NA",
        "NR",
        "NG",
        "NL",
        "NP",
        "NO",
        "NF",
        "AL",
        "DZ",
        "AW",
        "AM",
        "AR",
        "AC",
        "AG",
        "AQ",
        "AD",
        "AI",
        "AO",
        "AU",
        "QO",
        "AZ",
        "IE",
        "IM",
        "IS",
        "AF",
        "UY",
        "UZ",
        "IQ",
        "IR",
        "ET",
        "ID",
        "GQ",
        "EC",
        "SV",
        "ER",
        "EE",
        "IL",
        "OM",
        "AT",
        "CW",
        "CU",
        "CK",
        "KI",
        "KG",
        "CM",
        "KH",
        "CA",
        "KZ",
        "KY",
        "KE",
        "CV",
        "CP",
        "CX",
        "HR",
        "KW",
        "CO",
        "KM",
        "CR",
        "XK",
        "CI",
        "CG",
        "CD",
        "CC",
        "QA",
        "HM",
        "WF",
        "ZW",
        "ZM",
        "YE",
        "CF",
        "MP",
        "IO",
        "UN",
        "AE",
        "TC",
        "AX",
        "AS",
        "VI",
        "EU",
        "EZ",
        "VG",
        "BQ",
        "IC",
        "UM",
        "TF",
        "GF",
        "PF",
        "FO",
        "PS",
        "FK",
        "US",
        "GB",
        "UA",
        "UG",
        "SS",
        "ZA",
        "KR",
        "GS",
        "DG",
        "DK",
        "DO",
        "DM",
        "DE",
        "JE",
        "DJ",
        "GI",
        "JM",
        "JP",
        "JO",
        "GE",
        "GG",
        "GU",
        "GT",
        "GP",
        "GY",
        "GN",
        "GW",
        "GM",
        "GA",
        "GH",
        "GL",
        "GR",
        "GD",
        "EG",
        "IT",
        "FR",
        "PH",
        "FI",
        "FJ",
        "PN",
        "PW",
        "PY",
        "PA",
        "PK",
        "PG",
        "PE",
        "PL",
        "PT",
        "PR",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "ዓለም");
    namesMap.put("002", "አፍሪካ");
    namesMap.put("003", "ሰሜን አሜሪካ");
    namesMap.put("005", "ደቡብ አሜሪካ");
    namesMap.put("009", "ኦሽኒአ");
    namesMap.put("011", "ምስራቃዊ አፍሪካ");
    namesMap.put("013", "መካከለኛው አሜሪካ");
    namesMap.put("014", "ምዕራባዊ አፍሪካ");
    namesMap.put("015", "ሰሜናዊ አፍሪካ");
    namesMap.put("017", "መካከለኛው አፍሪካ");
    namesMap.put("018", "ደቡባዊ አፍሪካ");
    namesMap.put("019", "አሜሪካ");
    namesMap.put("021", "ሰሜናዊ አሜሪካ");
    namesMap.put("029", "ካሪቢያን");
    namesMap.put("030", "ምስራቃዊ እስያ");
    namesMap.put("034", "ደቡባዊ እሲያ");
    namesMap.put("035", "ምዕራባዊ ደቡብ እሲያ");
    namesMap.put("039", "ደቡባዊ አውሮፓ");
    namesMap.put("053", "አውስትራሌዥያ");
    namesMap.put("054", "ሜላኔዥያ");
    namesMap.put("057", "የማይክሮኔዥያን ክልል");
    namesMap.put("061", "ፖሊኔዥያ");
    namesMap.put("142", "እሲያ");
    namesMap.put("143", "መካከለኛው እሲያ");
    namesMap.put("145", "ምዕራባዊ እስያ");
    namesMap.put("150", "አውሮፓ");
    namesMap.put("151", "ምዕራባዊ አውሮፓ");
    namesMap.put("154", "ሰሜናዊ አውሮፓ");
    namesMap.put("155", "ምስራቃዊ አውሮፓ");
    namesMap.put("202", "ከሰሃራ በታች አፍሪካ");
    namesMap.put("419", "ላቲን አሜሪካ");
    namesMap.put("AC", "አሴንሽን ደሴት");
    namesMap.put("AD", "አንዶራ");
    namesMap.put("AE", "የተባበሩት ዓረብ ኤምሬትስ");
    namesMap.put("AF", "አፍጋኒስታን");
    namesMap.put("AG", "አንቲጓ እና ባሩዳ");
    namesMap.put("AI", "አንጉይላ");
    namesMap.put("AL", "አልባኒያ");
    namesMap.put("AM", "አርሜኒያ");
    namesMap.put("AO", "አንጐላ");
    namesMap.put("AQ", "አንታርክቲካ");
    namesMap.put("AR", "አርጀንቲና");
    namesMap.put("AS", "የአሜሪካ ሳሞአ");
    namesMap.put("AT", "ኦስትሪያ");
    namesMap.put("AU", "አውስትራልያ");
    namesMap.put("AW", "አሩባ");
    namesMap.put("AX", "የአላንድ ደሴቶች");
    namesMap.put("AZ", "አዘርባጃን");
    namesMap.put("BA", "ቦስኒያ እና ሄርዞጎቪኒያ");
    namesMap.put("BB", "ባርቤዶስ");
    namesMap.put("BD", "ባንግላዲሽ");
    namesMap.put("BE", "ቤልጄም");
    namesMap.put("BF", "ቡርኪና ፋሶ");
    namesMap.put("BG", "ቡልጌሪያ");
    namesMap.put("BH", "ባህሬን");
    namesMap.put("BI", "ብሩንዲ");
    namesMap.put("BJ", "ቤኒን");
    namesMap.put("BL", "ቅዱስ በርቴሎሜ");
    namesMap.put("BM", "ቤርሙዳ");
    namesMap.put("BN", "ብሩኒ");
    namesMap.put("BO", "ቦሊቪያ");
    namesMap.put("BQ", "የካሪቢያን ኔዘርላንድስ");
    namesMap.put("BR", "ብራዚል");
    namesMap.put("BS", "ባሃማስ");
    namesMap.put("BT", "ቡህታን");
    namesMap.put("BV", "ቡቬት ደሴት");
    namesMap.put("BW", "ቦትስዋና");
    namesMap.put("BY", "ቤላሩስ");
    namesMap.put("BZ", "በሊዝ");
    namesMap.put("CA", "ካናዳ");
    namesMap.put("CC", "ኮኮስ(ኬሊንግ) ደሴቶች");
    namesMap.put("CD", "ኮንጎ-ኪንሻሳ");
    namesMap.put("CF", "የመካከለኛው አፍሪካ ሪፐብሊክ");
    namesMap.put("CG", "ኮንጎ ብራዛቪል");
    namesMap.put("CH", "ስዊዘርላንድ");
    namesMap.put("CI", "ኮት ዲቯር");
    namesMap.put("CK", "ኩክ ደሴቶች");
    namesMap.put("CL", "ቺሊ");
    namesMap.put("CM", "ካሜሩን");
    namesMap.put("CN", "ቻይና");
    namesMap.put("CO", "ኮሎምቢያ");
    namesMap.put("CP", "ክሊፐርቶን ደሴት");
    namesMap.put("CR", "ኮስታሪካ");
    namesMap.put("CU", "ኩባ");
    namesMap.put("CV", "ኬፕ ቬርዴ");
    namesMap.put("CW", "ኩራሳዎ");
    namesMap.put("CX", "ክሪስማስ ደሴት");
    namesMap.put("CY", "ሳይፕረስ");
    namesMap.put("CZ", "ቼቺያ");
    namesMap.put("DE", "ጀርመን");
    namesMap.put("DG", "ዲዬጎ ጋርሺያ");
    namesMap.put("DJ", "ጂቡቲ");
    namesMap.put("DK", "ዴንማርክ");
    namesMap.put("DM", "ዶሚኒካ");
    namesMap.put("DO", "ዶመኒካን ሪፑብሊክ");
    namesMap.put("DZ", "አልጄሪያ");
    namesMap.put("EA", "ሴኡታና ሜሊላ");
    namesMap.put("EC", "ኢኳዶር");
    namesMap.put("EE", "ኤስቶኒያ");
    namesMap.put("EG", "ግብጽ");
    namesMap.put("EH", "ምዕራባዊ ሳህራ");
    namesMap.put("ER", "ኤርትራ");
    namesMap.put("ES", "ስፔን");
    namesMap.put("ET", "ኢትዮጵያ");
    namesMap.put("EU", "የአውሮፓ ህብረት");
    namesMap.put("EZ", "የአውሮፓ ዞን");
    namesMap.put("FI", "ፊንላንድ");
    namesMap.put("FJ", "ፊጂ");
    namesMap.put("FK", "የፎክላንድ ደሴቶች");
    namesMap.put("FM", "ሚክሮኔዢያ");
    namesMap.put("FO", "የፋሮ ደሴቶች");
    namesMap.put("FR", "ፈረንሳይ");
    namesMap.put("GA", "ጋቦን");
    namesMap.put("GB", "ዩናይትድ ኪንግደም");
    namesMap.put("GD", "ግሬናዳ");
    namesMap.put("GE", "ጆርጂያ");
    namesMap.put("GF", "የፈረንሳይ ጉዊአና");
    namesMap.put("GG", "ጉርነሲ");
    namesMap.put("GH", "ጋና");
    namesMap.put("GI", "ጂብራልተር");
    namesMap.put("GL", "ግሪንላንድ");
    namesMap.put("GM", "ጋምቢያ");
    namesMap.put("GN", "ጊኒ");
    namesMap.put("GP", "ጉዋደሉፕ");
    namesMap.put("GQ", "ኢኳቶሪያል ጊኒ");
    namesMap.put("GR", "ግሪክ");
    namesMap.put("GS", "ደቡብ ጆርጂያ እና የደቡብ ሳንድዊች ደሴቶች");
    namesMap.put("GT", "ጉዋቲማላ");
    namesMap.put("GU", "ጉዋም");
    namesMap.put("GW", "ጊኒ ቢሳኦ");
    namesMap.put("GY", "ጉያና");
    namesMap.put("HK", "ሆንግ ኮንግ ልዩ የአስተዳደር ክልል ቻይና");
    namesMap.put("HM", "ኽርድ ደሴቶችና ማክዶናልድ ደሴቶች");
    namesMap.put("HN", "ሆንዱራስ");
    namesMap.put("HR", "ክሮኤሽያ");
    namesMap.put("HT", "ሀይቲ");
    namesMap.put("HU", "ሀንጋሪ");
    namesMap.put("IC", "የካናሪ ደሴቶች");
    namesMap.put("ID", "ኢንዶኔዢያ");
    namesMap.put("IE", "አየርላንድ");
    namesMap.put("IL", "እስራኤል");
    namesMap.put("IM", "አይል ኦፍ ማን");
    namesMap.put("IN", "ህንድ");
    namesMap.put("IO", "የብሪታኒያ ህንድ ውቂያኖስ ግዛት");
    namesMap.put("IQ", "ኢራቅ");
    namesMap.put("IR", "ኢራን");
    namesMap.put("IS", "አይስላንድ");
    namesMap.put("IT", "ጣሊያን");
    namesMap.put("JE", "ጀርሲ");
    namesMap.put("JM", "ጃማይካ");
    namesMap.put("JO", "ጆርዳን");
    namesMap.put("JP", "ጃፓን");
    namesMap.put("KE", "ኬንያ");
    namesMap.put("KG", "ኪርጊስታን");
    namesMap.put("KH", "ካምቦዲያ");
    namesMap.put("KI", "ኪሪባቲ");
    namesMap.put("KM", "ኮሞሮስ");
    namesMap.put("KN", "ቅዱስ ኪትስ እና ኔቪስ");
    namesMap.put("KP", "ሰሜን ኮሪያ");
    namesMap.put("KR", "ደቡብ ኮሪያ");
    namesMap.put("KW", "ክዌት");
    namesMap.put("KY", "ካይማን ደሴቶች");
    namesMap.put("KZ", "ካዛኪስታን");
    namesMap.put("LA", "ላኦስ");
    namesMap.put("LB", "ሊባኖስ");
    namesMap.put("LC", "ሴንት ሉቺያ");
    namesMap.put("LI", "ሊችተንስታይን");
    namesMap.put("LK", "ሲሪላንካ");
    namesMap.put("LR", "ላይቤሪያ");
    namesMap.put("LS", "ሌሶቶ");
    namesMap.put("LT", "ሊቱዌኒያ");
    namesMap.put("LU", "ሉክሰምበርግ");
    namesMap.put("LV", "ላትቪያ");
    namesMap.put("LY", "ሊቢያ");
    namesMap.put("MA", "ሞሮኮ");
    namesMap.put("MC", "ሞናኮ");
    namesMap.put("MD", "ሞልዶቫ");
    namesMap.put("ME", "ሞንተኔግሮ");
    namesMap.put("MF", "ሴንት ማርቲን");
    namesMap.put("MG", "ማዳጋስካር");
    namesMap.put("MH", "ማርሻል አይላንድ");
    namesMap.put("MK", "መቄዶንያ");
    namesMap.put("ML", "ማሊ");
    namesMap.put("MM", "ማይናማር(በርማ)");
    namesMap.put("MN", "ሞንጎሊያ");
    namesMap.put("MO", "ማካኡ ልዩ የአስተዳደር ክልል ቻይና");
    namesMap.put("MP", "የሰሜናዊ ማሪያና ደሴቶች");
    namesMap.put("MQ", "ማርቲኒክ");
    namesMap.put("MR", "ሞሪቴኒያ");
    namesMap.put("MS", "ሞንትሴራት");
    namesMap.put("MT", "ማልታ");
    namesMap.put("MU", "ሞሪሸስ");
    namesMap.put("MV", "ማልዲቭስ");
    namesMap.put("MW", "ማላዊ");
    namesMap.put("MX", "ሜክሲኮ");
    namesMap.put("MY", "ማሌዢያ");
    namesMap.put("MZ", "ሞዛምቢክ");
    namesMap.put("NA", "ናሚቢያ");
    namesMap.put("NC", "ኒው ካሌዶኒያ");
    namesMap.put("NE", "ኒጀር");
    namesMap.put("NF", "ኖርፎልክ ደሴት");
    namesMap.put("NG", "ናይጄሪያ");
    namesMap.put("NI", "ኒካራጓ");
    namesMap.put("NL", "ኔዘርላንድ");
    namesMap.put("NO", "ኖርዌይ");
    namesMap.put("NP", "ኔፓል");
    namesMap.put("NR", "ናኡሩ");
    namesMap.put("NU", "ኒኡይ");
    namesMap.put("NZ", "ኒው ዚላንድ");
    namesMap.put("OM", "ኦማን");
    namesMap.put("PA", "ፓናማ");
    namesMap.put("PE", "ፔሩ");
    namesMap.put("PF", "የፈረንሳይ ፖሊኔዢያ");
    namesMap.put("PG", "ፓፑዋ ኒው ጊኒ");
    namesMap.put("PH", "ፊሊፒንስ");
    namesMap.put("PK", "ፓኪስታን");
    namesMap.put("PL", "ፖላንድ");
    namesMap.put("PM", "ቅዱስ ፒዬር እና ሚኩኤሎን");
    namesMap.put("PN", "ፒትካኢርን አይስላንድ");
    namesMap.put("PR", "ፖርታ ሪኮ");
    namesMap.put("PS", "የፍልስጤም ግዛት");
    namesMap.put("PT", "ፖርቱጋል");
    namesMap.put("PW", "ፓላው");
    namesMap.put("PY", "ፓራጓይ");
    namesMap.put("QA", "ኳታር");
    namesMap.put("QO", "አውትላይንግ ኦሽንያ");
    namesMap.put("RE", "ሪዩኒየን");
    namesMap.put("RO", "ሮሜኒያ");
    namesMap.put("RS", "ሰርብያ");
    namesMap.put("RU", "ሩስያ");
    namesMap.put("RW", "ሩዋንዳ");
    namesMap.put("SA", "ሳውድአረቢያ");
    namesMap.put("SB", "ሰሎሞን ደሴት");
    namesMap.put("SC", "ሲሼልስ");
    namesMap.put("SD", "ሱዳን");
    namesMap.put("SE", "ስዊድን");
    namesMap.put("SG", "ሲንጋፖር");
    namesMap.put("SH", "ሴንት ሄለና");
    namesMap.put("SI", "ስሎቬኒያ");
    namesMap.put("SJ", "ስቫልባርድ እና ጃን ማየን");
    namesMap.put("SK", "ስሎቫኪያ");
    namesMap.put("SL", "ሴራሊዮን");
    namesMap.put("SM", "ሳን ማሪኖ");
    namesMap.put("SN", "ሴኔጋል");
    namesMap.put("SO", "ሱማሌ");
    namesMap.put("SR", "ሱሪናም");
    namesMap.put("SS", "ደቡብ ሱዳን");
    namesMap.put("ST", "ሳኦ ቶሜ እና ፕሪንሲፔ");
    namesMap.put("SV", "ኤል ሳልቫዶር");
    namesMap.put("SX", "ሲንት ማርተን");
    namesMap.put("SY", "ሲሪያ");
    namesMap.put("SZ", "ሱዋዚላንድ");
    namesMap.put("TA", "ትሪስታን ዲ ኩንሃ");
    namesMap.put("TC", "የቱርኮችና የካኢኮስ ደሴቶች");
    namesMap.put("TD", "ቻድ");
    namesMap.put("TF", "የፈረንሳይ ደቡባዊ ግዛቶች");
    namesMap.put("TG", "ቶጐ");
    namesMap.put("TH", "ታይላንድ");
    namesMap.put("TJ", "ታጃኪስታን");
    namesMap.put("TK", "ቶክላው");
    namesMap.put("TL", "ቲሞር ሌስቴ");
    namesMap.put("TM", "ቱርክሜኒስታን");
    namesMap.put("TN", "ቱኒዚያ");
    namesMap.put("TO", "ቶንጋ");
    namesMap.put("TR", "ቱርክ");
    namesMap.put("TT", "ትሪናዳድ እና ቶቤጎ");
    namesMap.put("TV", "ቱቫሉ");
    namesMap.put("TW", "ታይዋን");
    namesMap.put("TZ", "ታንዛኒያ");
    namesMap.put("UA", "ዩክሬን");
    namesMap.put("UG", "ዩጋንዳ");
    namesMap.put("UM", "የዩ ኤስ ጠረፍ ላይ ያሉ ደሴቶች");
    namesMap.put("UN", "የተባበሩት መንግስታት");
    namesMap.put("US", "ዩናይትድ ስቴትስ");
    namesMap.put("UY", "ኡራጓይ");
    namesMap.put("UZ", "ኡዝቤኪስታን");
    namesMap.put("VA", "ቫቲካን ከተማ");
    namesMap.put("VC", "ቅዱስ ቪንሴንት እና ግሬናዲንስ");
    namesMap.put("VE", "ቬንዙዌላ");
    namesMap.put("VG", "የእንግሊዝ ቨርጂን ደሴቶች");
    namesMap.put("VI", "የአሜሪካ ቨርጂን ደሴቶች");
    namesMap.put("VN", "ቬትናም");
    namesMap.put("VU", "ቫኑአቱ");
    namesMap.put("WF", "ዋሊስ እና ፉቱና ደሴቶች");
    namesMap.put("WS", "ሳሞአ");
    namesMap.put("XK", "ኮሶቮ");
    namesMap.put("YE", "የመን");
    namesMap.put("YT", "ሜይኦቴ");
    namesMap.put("ZA", "ደቡብ አፍሪካ");
    namesMap.put("ZM", "ዛምቢያ");
    namesMap.put("ZW", "ዚምቧቤ");
    namesMap.put("ZZ", "ያልታወቀ ክልል");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "ዓለም",
        "002": "አፍሪካ",
        "003": "ሰሜን አሜሪካ",
        "005": "ደቡብ አሜሪካ",
        "009": "ኦሽኒአ",
        "011": "ምስራቃዊ አፍሪካ",
        "013": "መካከለኛው አሜሪካ",
        "014": "ምዕራባዊ አፍሪካ",
        "015": "ሰሜናዊ አፍሪካ",
        "017": "መካከለኛው አፍሪካ",
        "018": "ደቡባዊ አፍሪካ",
        "019": "አሜሪካ",
        "021": "ሰሜናዊ አሜሪካ",
        "029": "ካሪቢያን",
        "030": "ምስራቃዊ እስያ",
        "034": "ደቡባዊ እሲያ",
        "035": "ምዕራባዊ ደቡብ እሲያ",
        "039": "ደቡባዊ አውሮፓ",
        "053": "አውስትራሌዥያ",
        "054": "ሜላኔዥያ",
        "057": "የማይክሮኔዥያን ክልል",
        "061": "ፖሊኔዥያ",
        "142": "እሲያ",
        "143": "መካከለኛው እሲያ",
        "145": "ምዕራባዊ እስያ",
        "150": "አውሮፓ",
        "151": "ምዕራባዊ አውሮፓ",
        "154": "ሰሜናዊ አውሮፓ",
        "155": "ምስራቃዊ አውሮፓ",
        "202": "ከሰሃራ በታች አፍሪካ",
        "419": "ላቲን አሜሪካ",
        "AC": "አሴንሽን ደሴት",
        "AD": "አንዶራ",
        "AE": "የተባበሩት ዓረብ ኤምሬትስ",
        "AF": "አፍጋኒስታን",
        "AG": "አንቲጓ እና ባሩዳ",
        "AI": "አንጉይላ",
        "AL": "አልባኒያ",
        "AM": "አርሜኒያ",
        "AO": "አንጐላ",
        "AQ": "አንታርክቲካ",
        "AR": "አርጀንቲና",
        "AS": "የአሜሪካ ሳሞአ",
        "AT": "ኦስትሪያ",
        "AU": "አውስትራልያ",
        "AW": "አሩባ",
        "AX": "የአላንድ ደሴቶች",
        "AZ": "አዘርባጃን",
        "BA": "ቦስኒያ እና ሄርዞጎቪኒያ",
        "BB": "ባርቤዶስ",
        "BD": "ባንግላዲሽ",
        "BE": "ቤልጄም",
        "BF": "ቡርኪና ፋሶ",
        "BG": "ቡልጌሪያ",
        "BH": "ባህሬን",
        "BI": "ብሩንዲ",
        "BJ": "ቤኒን",
        "BL": "ቅዱስ በርቴሎሜ",
        "BM": "ቤርሙዳ",
        "BN": "ብሩኒ",
        "BO": "ቦሊቪያ",
        "BQ": "የካሪቢያን ኔዘርላንድስ",
        "BR": "ብራዚል",
        "BS": "ባሃማስ",
        "BT": "ቡህታን",
        "BV": "ቡቬት ደሴት",
        "BW": "ቦትስዋና",
        "BY": "ቤላሩስ",
        "BZ": "በሊዝ",
        "CA": "ካናዳ",
        "CC": "ኮኮስ(ኬሊንግ) ደሴቶች",
        "CD": "ኮንጎ-ኪንሻሳ",
        "CF": "የመካከለኛው አፍሪካ ሪፐብሊክ",
        "CG": "ኮንጎ ብራዛቪል",
        "CH": "ስዊዘርላንድ",
        "CI": "ኮት ዲቯር",
        "CK": "ኩክ ደሴቶች",
        "CL": "ቺሊ",
        "CM": "ካሜሩን",
        "CN": "ቻይና",
        "CO": "ኮሎምቢያ",
        "CP": "ክሊፐርቶን ደሴት",
        "CR": "ኮስታሪካ",
        "CU": "ኩባ",
        "CV": "ኬፕ ቬርዴ",
        "CW": "ኩራሳዎ",
        "CX": "ክሪስማስ ደሴት",
        "CY": "ሳይፕረስ",
        "CZ": "ቼቺያ",
        "DE": "ጀርመን",
        "DG": "ዲዬጎ ጋርሺያ",
        "DJ": "ጂቡቲ",
        "DK": "ዴንማርክ",
        "DM": "ዶሚኒካ",
        "DO": "ዶመኒካን ሪፑብሊክ",
        "DZ": "አልጄሪያ",
        "EA": "ሴኡታና ሜሊላ",
        "EC": "ኢኳዶር",
        "EE": "ኤስቶኒያ",
        "EG": "ግብጽ",
        "EH": "ምዕራባዊ ሳህራ",
        "ER": "ኤርትራ",
        "ES": "ስፔን",
        "ET": "ኢትዮጵያ",
        "EU": "የአውሮፓ ህብረት",
        "EZ": "የአውሮፓ ዞን",
        "FI": "ፊንላንድ",
        "FJ": "ፊጂ",
        "FK": "የፎክላንድ ደሴቶች",
        "FM": "ሚክሮኔዢያ",
        "FO": "የፋሮ ደሴቶች",
        "FR": "ፈረንሳይ",
        "GA": "ጋቦን",
        "GB": "ዩናይትድ ኪንግደም",
        "GD": "ግሬናዳ",
        "GE": "ጆርጂያ",
        "GF": "የፈረንሳይ ጉዊአና",
        "GG": "ጉርነሲ",
        "GH": "ጋና",
        "GI": "ጂብራልተር",
        "GL": "ግሪንላንድ",
        "GM": "ጋምቢያ",
        "GN": "ጊኒ",
        "GP": "ጉዋደሉፕ",
        "GQ": "ኢኳቶሪያል ጊኒ",
        "GR": "ግሪክ",
        "GS": "ደቡብ ጆርጂያ እና የደቡብ ሳንድዊች ደሴቶች",
        "GT": "ጉዋቲማላ",
        "GU": "ጉዋም",
        "GW": "ጊኒ ቢሳኦ",
        "GY": "ጉያና",
        "HK": "ሆንግ ኮንግ ልዩ የአስተዳደር ክልል ቻይና",
        "HM": "ኽርድ ደሴቶችና ማክዶናልድ ደሴቶች",
        "HN": "ሆንዱራስ",
        "HR": "ክሮኤሽያ",
        "HT": "ሀይቲ",
        "HU": "ሀንጋሪ",
        "IC": "የካናሪ ደሴቶች",
        "ID": "ኢንዶኔዢያ",
        "IE": "አየርላንድ",
        "IL": "እስራኤል",
        "IM": "አይል ኦፍ ማን",
        "IN": "ህንድ",
        "IO": "የብሪታኒያ ህንድ ውቂያኖስ ግዛት",
        "IQ": "ኢራቅ",
        "IR": "ኢራን",
        "IS": "አይስላንድ",
        "IT": "ጣሊያን",
        "JE": "ጀርሲ",
        "JM": "ጃማይካ",
        "JO": "ጆርዳን",
        "JP": "ጃፓን",
        "KE": "ኬንያ",
        "KG": "ኪርጊስታን",
        "KH": "ካምቦዲያ",
        "KI": "ኪሪባቲ",
        "KM": "ኮሞሮስ",
        "KN": "ቅዱስ ኪትስ እና ኔቪስ",
        "KP": "ሰሜን ኮሪያ",
        "KR": "ደቡብ ኮሪያ",
        "KW": "ክዌት",
        "KY": "ካይማን ደሴቶች",
        "KZ": "ካዛኪስታን",
        "LA": "ላኦስ",
        "LB": "ሊባኖስ",
        "LC": "ሴንት ሉቺያ",
        "LI": "ሊችተንስታይን",
        "LK": "ሲሪላንካ",
        "LR": "ላይቤሪያ",
        "LS": "ሌሶቶ",
        "LT": "ሊቱዌኒያ",
        "LU": "ሉክሰምበርግ",
        "LV": "ላትቪያ",
        "LY": "ሊቢያ",
        "MA": "ሞሮኮ",
        "MC": "ሞናኮ",
        "MD": "ሞልዶቫ",
        "ME": "ሞንተኔግሮ",
        "MF": "ሴንት ማርቲን",
        "MG": "ማዳጋስካር",
        "MH": "ማርሻል አይላንድ",
        "MK": "መቄዶንያ",
        "ML": "ማሊ",
        "MM": "ማይናማር(በርማ)",
        "MN": "ሞንጎሊያ",
        "MO": "ማካኡ ልዩ የአስተዳደር ክልል ቻይና",
        "MP": "የሰሜናዊ ማሪያና ደሴቶች",
        "MQ": "ማርቲኒክ",
        "MR": "ሞሪቴኒያ",
        "MS": "ሞንትሴራት",
        "MT": "ማልታ",
        "MU": "ሞሪሸስ",
        "MV": "ማልዲቭስ",
        "MW": "ማላዊ",
        "MX": "ሜክሲኮ",
        "MY": "ማሌዢያ",
        "MZ": "ሞዛምቢክ",
        "NA": "ናሚቢያ",
        "NC": "ኒው ካሌዶኒያ",
        "NE": "ኒጀር",
        "NF": "ኖርፎልክ ደሴት",
        "NG": "ናይጄሪያ",
        "NI": "ኒካራጓ",
        "NL": "ኔዘርላንድ",
        "NO": "ኖርዌይ",
        "NP": "ኔፓል",
        "NR": "ናኡሩ",
        "NU": "ኒኡይ",
        "NZ": "ኒው ዚላንድ",
        "OM": "ኦማን",
        "PA": "ፓናማ",
        "PE": "ፔሩ",
        "PF": "የፈረንሳይ ፖሊኔዢያ",
        "PG": "ፓፑዋ ኒው ጊኒ",
        "PH": "ፊሊፒንስ",
        "PK": "ፓኪስታን",
        "PL": "ፖላንድ",
        "PM": "ቅዱስ ፒዬር እና ሚኩኤሎን",
        "PN": "ፒትካኢርን አይስላንድ",
        "PR": "ፖርታ ሪኮ",
        "PS": "የፍልስጤም ግዛት",
        "PT": "ፖርቱጋል",
        "PW": "ፓላው",
        "PY": "ፓራጓይ",
        "QA": "ኳታር",
        "QO": "አውትላይንግ ኦሽንያ",
        "RE": "ሪዩኒየን",
        "RO": "ሮሜኒያ",
        "RS": "ሰርብያ",
        "RU": "ሩስያ",
        "RW": "ሩዋንዳ",
        "SA": "ሳውድአረቢያ",
        "SB": "ሰሎሞን ደሴት",
        "SC": "ሲሼልስ",
        "SD": "ሱዳን",
        "SE": "ስዊድን",
        "SG": "ሲንጋፖር",
        "SH": "ሴንት ሄለና",
        "SI": "ስሎቬኒያ",
        "SJ": "ስቫልባርድ እና ጃን ማየን",
        "SK": "ስሎቫኪያ",
        "SL": "ሴራሊዮን",
        "SM": "ሳን ማሪኖ",
        "SN": "ሴኔጋል",
        "SO": "ሱማሌ",
        "SR": "ሱሪናም",
        "SS": "ደቡብ ሱዳን",
        "ST": "ሳኦ ቶሜ እና ፕሪንሲፔ",
        "SV": "ኤል ሳልቫዶር",
        "SX": "ሲንት ማርተን",
        "SY": "ሲሪያ",
        "SZ": "ሱዋዚላንድ",
        "TA": "ትሪስታን ዲ ኩንሃ",
        "TC": "የቱርኮችና የካኢኮስ ደሴቶች",
        "TD": "ቻድ",
        "TF": "የፈረንሳይ ደቡባዊ ግዛቶች",
        "TG": "ቶጐ",
        "TH": "ታይላንድ",
        "TJ": "ታጃኪስታን",
        "TK": "ቶክላው",
        "TL": "ቲሞር ሌስቴ",
        "TM": "ቱርክሜኒስታን",
        "TN": "ቱኒዚያ",
        "TO": "ቶንጋ",
        "TR": "ቱርክ",
        "TT": "ትሪናዳድ እና ቶቤጎ",
        "TV": "ቱቫሉ",
        "TW": "ታይዋን",
        "TZ": "ታንዛኒያ",
        "UA": "ዩክሬን",
        "UG": "ዩጋንዳ",
        "UM": "የዩ ኤስ ጠረፍ ላይ ያሉ ደሴቶች",
        "UN": "የተባበሩት መንግስታት",
        "US": "ዩናይትድ ስቴትስ",
        "UY": "ኡራጓይ",
        "UZ": "ኡዝቤኪስታን",
        "VA": "ቫቲካን ከተማ",
        "VC": "ቅዱስ ቪንሴንት እና ግሬናዲንስ",
        "VE": "ቬንዙዌላ",
        "VG": "የእንግሊዝ ቨርጂን ደሴቶች",
        "VI": "የአሜሪካ ቨርጂን ደሴቶች",
        "VN": "ቬትናም",
        "VU": "ቫኑአቱ",
        "WF": "ዋሊስ እና ፉቱና ደሴቶች",
        "WS": "ሳሞአ",
        "XK": "ኮሶቮ",
        "YE": "የመን",
        "YT": "ሜይኦቴ",
        "ZA": "ደቡብ አፍሪካ",
        "ZM": "ዛምቢያ",
        "ZW": "ዚምቧቤ",
        "ZZ": "ያልታወቀ ክልል"
    };
  }-*/;
}
