/*
 * Decompiled with CFR 0.152.
 */
package org.grpcmock.interceptors;

import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;
import org.grpcmock.GrpcMock;
import org.grpcmock.definitions.verification.RequestPattern;
import org.grpcmock.interceptors.CapturedRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RequestCaptureInterceptor
implements ServerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(GrpcMock.class);
    private static final String SEPARATOR = "----------------------------------------";
    private static final Context.Key<CapturedRequest> CAPTURED_REQUEST = Context.key((String)"capture_request");
    private final Queue<CapturedRequest> capturedRequests = new ConcurrentLinkedQueue<CapturedRequest>();

    public <ReqT> List<CapturedRequest<ReqT>> requestsFor(@Nonnull RequestPattern<ReqT> requestPattern) {
        Objects.requireNonNull(requestPattern);
        ArrayList<CapturedRequest<ReqT>> matchedRequests = new ArrayList<CapturedRequest<ReqT>>();
        for (CapturedRequest capturedRequest : this.capturedRequests) {
            if (!requestPattern.matches(capturedRequest)) continue;
            matchedRequests.add(requestPattern.normalizedCapturedRequest(capturedRequest));
        }
        return matchedRequests;
    }

    public int callCountFor(@Nonnull RequestPattern<?> requestPattern) {
        return this.requestsFor(requestPattern).size();
    }

    public void clear() {
        this.capturedRequests.clear();
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata metadata, ServerCallHandler<ReqT, RespT> next) {
        MethodDescriptor method = call.getMethodDescriptor();
        Metadata headers = this.getCapturedMetadata(metadata);
        final CopyOnWriteArrayList requests = new CopyOnWriteArrayList();
        final CapturedRequest capturedRequest = this.captureRequest(method, headers, requests);
        ForwardingServerCall.SimpleForwardingServerCall forwardingCall = new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

            public void close(Status status, Metadata trailers) {
                capturedRequest.setCloseStatus(status);
                super.close(status, trailers);
            }
        };
        Context ctx = Context.current().withValue(CAPTURED_REQUEST, capturedRequest);
        ServerCall.Listener interceptedListener = Contexts.interceptCall((Context)ctx, (ServerCall)forwardingCall, (Metadata)metadata, next);
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(interceptedListener){

            public void onMessage(ReqT message) {
                requests.add(message);
                if (log.isInfoEnabled()) {
                    log.info("\n{}\nReceived request:\n{}\n{}", new Object[]{RequestCaptureInterceptor.SEPARATOR, capturedRequest, RequestCaptureInterceptor.SEPARATOR});
                }
                super.onMessage(message);
            }
        };
    }

    private <ReqT> CapturedRequest<ReqT> captureRequest(MethodDescriptor<ReqT, ?> method, Metadata headers, List<ReqT> requests) {
        CapturedRequest<ReqT> capturedRequest = new CapturedRequest<ReqT>(method, headers, requests);
        if (!this.capturedRequests.offer(capturedRequest)) {
            log.warn("Failed to capture request in the queue");
        }
        return capturedRequest;
    }

    private Metadata getCapturedMetadata(Metadata incomingMetadata) {
        Metadata capturedHeaders = new Metadata();
        capturedHeaders.merge(incomingMetadata);
        return capturedHeaders;
    }

    public static <ReqT> CapturedRequest<ReqT> getCapturedRequest() {
        return (CapturedRequest)CAPTURED_REQUEST.get();
    }
}

