/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.server.impl.event.structured;

import java.net.InetAddress;
import org.graylog2.syslog4j.impl.message.structured.StructuredSyslogMessage;
import org.graylog2.syslog4j.server.impl.event.SyslogServerEvent;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class StructuredSyslogServerEvent
extends SyslogServerEvent {
    private static final long serialVersionUID = 1676499796406044315L;
    protected String applicationName = "unknown";
    protected String processId = null;
    protected DateTime dateTime = null;
    protected DateTimeFormatter dateTimeFormatter = null;

    public StructuredSyslogServerEvent(byte[] message, int length, InetAddress inetAddress) {
        this.initialize(message, length, inetAddress);
        this.parse();
    }

    public StructuredSyslogServerEvent(String message, InetAddress inetAddress) {
        this.initialize(message, inetAddress);
        this.parse();
    }

    public DateTimeFormatter getDateTimeFormatter() {
        if (this.dateTimeFormatter == null) {
            this.dateTimeFormatter = ISODateTimeFormat.dateTime();
        }
        return this.dateTimeFormatter;
    }

    public void setDateTimeFormatter(Object dateTimeFormatter) {
        this.dateTimeFormatter = (DateTimeFormatter)dateTimeFormatter;
    }

    protected void parseApplicationName() {
        int i = this.message.indexOf(32);
        if (i > -1) {
            this.applicationName = this.message.substring(0, i).trim();
            this.message = this.message.substring(i + 1);
            this.parseProcessId();
        }
        if ("-".equals(this.applicationName)) {
            this.applicationName = null;
        }
    }

    protected void parseProcessId() {
        int i = this.message.indexOf(32);
        if (i > -1) {
            this.processId = this.message.substring(0, i).trim();
            this.message = this.message.substring(i + 1);
        }
        if ("-".equals(this.processId)) {
            this.processId = null;
        }
    }

    protected void parseDate() {
        int i = this.message.indexOf(32);
        this.message = this.message.substring(i + 1);
        i = this.message.indexOf(32);
        if (i > -1) {
            String dateString = this.message.substring(0, i).trim();
            try {
                DateTimeFormatter formatter = this.getDateTimeFormatter();
                this.dateTime = formatter.parseDateTime(dateString);
                this.date = this.dateTime.toDate();
                this.message = this.message.substring(dateString.length() + 1);
            }
            catch (Exception e) {
                super.parseDate();
            }
        }
    }

    protected void parseHost() {
        int i = this.message.indexOf(32);
        if (i > -1) {
            this.host = this.message.substring(0, i).trim();
            this.message = this.message.substring(i + 1);
            this.parseApplicationName();
        }
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getProcessId() {
        return this.processId;
    }

    public DateTime getDateTime() {
        return this.dateTime;
    }

    public StructuredSyslogMessage getStructuredMessage() {
        try {
            return StructuredSyslogMessage.fromString(this.getMessage());
        }
        catch (IllegalArgumentException e) {
            return new StructuredSyslogMessage(null, null, this.getMessage());
        }
    }
}

