/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl.net.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.AbstractSyslogWriter;
import org.graylog2.syslog4j.impl.net.AbstractNetSyslog;

public class UDPNetSyslog
extends AbstractNetSyslog {
    private static final long serialVersionUID = 5259485504549037999L;
    protected DatagramSocket socket = null;

    public void initialize() throws SyslogRuntimeException {
        super.initialize();
        this.createDatagramSocket(true);
    }

    protected synchronized void createDatagramSocket(boolean initialize) {
        try {
            this.socket = new DatagramSocket();
        }
        catch (SocketException se) {
            if (initialize) {
                if (this.syslogConfig.isThrowExceptionOnInitialize()) {
                    throw new SyslogRuntimeException(se);
                }
            }
            throw new SyslogRuntimeException(se);
        }
        if (this.socket == null) {
            throw new SyslogRuntimeException("Cannot seem to get a Datagram socket");
        }
    }

    protected void write(int level, byte[] message) throws SyslogRuntimeException {
        if (this.socket == null) {
            this.createDatagramSocket(false);
        }
        InetAddress hostAddress = this.getHostAddress();
        DatagramPacket packet = new DatagramPacket(message, message.length, hostAddress, this.syslogConfig.getPort());
        int attempts = 0;
        while (attempts != -1 && attempts < this.netSyslogConfig.getWriteRetries() + 1) {
            try {
                this.socket.send(packet);
                attempts = -1;
            }
            catch (IOException ioe) {
                if (attempts != this.netSyslogConfig.getWriteRetries() + 1) continue;
                throw new SyslogRuntimeException(ioe);
            }
        }
    }

    public void flush() throws SyslogRuntimeException {
        this.shutdown();
        this.createDatagramSocket(true);
    }

    public void shutdown() throws SyslogRuntimeException {
        if (this.socket != null) {
            this.socket.close();
            this.socket = null;
        }
    }

    public AbstractSyslogWriter getWriter() {
        return null;
    }

    public void returnWriter(AbstractSyslogWriter syslogWriter) {
    }
}

