/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.impl.message.modifier.mac;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;
import org.graylog2.syslog4j.SyslogIF;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.message.modifier.AbstractSyslogMessageModifier;
import org.graylog2.syslog4j.impl.message.modifier.mac.MacSyslogMessageModifierConfig;
import org.graylog2.syslog4j.util.Base64;
import org.graylog2.syslog4j.util.SyslogUtility;

public class MacSyslogMessageModifier
extends AbstractSyslogMessageModifier {
    private static final long serialVersionUID = 5054979194802197540L;
    protected MacSyslogMessageModifierConfig config = null;
    protected Mac mac = null;

    public MacSyslogMessageModifier(MacSyslogMessageModifierConfig config) throws SyslogRuntimeException {
        super(config);
        this.config = config;
        try {
            this.mac = Mac.getInstance(config.getMacAlgorithm());
            this.mac.init(config.getKey());
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new SyslogRuntimeException(nsae);
        }
        catch (InvalidKeyException ike) {
            throw new SyslogRuntimeException(ike);
        }
    }

    public static MacSyslogMessageModifier createHmacSHA1(Key key) {
        return new MacSyslogMessageModifier(MacSyslogMessageModifierConfig.createHmacSHA1(key));
    }

    public static MacSyslogMessageModifier createHmacSHA1(String base64Key) {
        return new MacSyslogMessageModifier(MacSyslogMessageModifierConfig.createHmacSHA1(base64Key));
    }

    public static MacSyslogMessageModifier createHmacSHA256(Key key) {
        return new MacSyslogMessageModifier(MacSyslogMessageModifierConfig.createHmacSHA256(key));
    }

    public static MacSyslogMessageModifier createHmacSHA256(String base64Key) {
        return new MacSyslogMessageModifier(MacSyslogMessageModifierConfig.createHmacSHA256(base64Key));
    }

    public static MacSyslogMessageModifier createHmacSHA512(Key key) {
        return new MacSyslogMessageModifier(MacSyslogMessageModifierConfig.createHmacSHA512(key));
    }

    public static MacSyslogMessageModifier createHmacSHA512(String base64Key) {
        return new MacSyslogMessageModifier(MacSyslogMessageModifierConfig.createHmacSHA512(base64Key));
    }

    public static MacSyslogMessageModifier createHmacMD5(Key key) {
        return new MacSyslogMessageModifier(MacSyslogMessageModifierConfig.createHmacMD5(key));
    }

    public static MacSyslogMessageModifier createHmacMD5(String base64Key) {
        return new MacSyslogMessageModifier(MacSyslogMessageModifierConfig.createHmacMD5(base64Key));
    }

    public MacSyslogMessageModifierConfig getConfig() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String modify(SyslogIF syslog, int facility, int level, String message) {
        Mac mac = this.mac;
        synchronized (mac) {
            byte[] messageBytes = SyslogUtility.getBytes(syslog.getConfig(), message);
            StringBuffer buffer = new StringBuffer(message);
            byte[] macBytes = this.mac.doFinal(messageBytes);
            String macString = Base64.encodeBytes(macBytes, 8);
            buffer.append(this.config.getPrefix());
            buffer.append(macString);
            buffer.append(this.config.getSuffix());
            return buffer.toString();
        }
    }

    public boolean verify(String message, String base64Signature) {
        byte[] signature = Base64.decode(base64Signature);
        return this.verify(message, signature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(String message, byte[] signature) {
        Mac mac = this.mac;
        synchronized (mac) {
            byte[] messageBytes = SyslogUtility.getBytes(this.config, message);
            byte[] macBytes = this.mac.doFinal(messageBytes);
            return Arrays.equals(macBytes, signature);
        }
    }
}

