/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.EigenDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.graphstream.algorithm.Algorithm;
import org.graphstream.algorithm.NotInitializedException;
import org.graphstream.algorithm.generator.BarabasiAlbertGenerator;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.implementations.AdjacencyListGraph;
import org.graphstream.stream.Sink;

public class Spectrum
implements Algorithm {
    protected EigenValuesAlgorithm mode;
    protected Graph graph;
    protected EigenDecomposition decomposition;

    @Override
    public void init(Graph graph) {
        if (graph == null) {
            throw new NullPointerException();
        }
        this.graph = graph;
    }

    @Override
    public void compute() {
        if (this.graph == null) {
            throw new NotInitializedException(this);
        }
        int m = this.graph.getNodeCount();
        Array2DRowRealMatrix a = new Array2DRowRealMatrix(m, m);
        for (int idx1 = 0; idx1 < m; ++idx1) {
            for (int idx2 = 0; idx2 < m; ++idx2) {
                Edge e = this.graph.getNode(idx1).getEdgeToward(idx2);
                a.setEntry(idx1, idx2, e != null ? 1.0 : 0.0);
            }
        }
        this.decomposition = new EigenDecomposition((RealMatrix)a, 0.0);
    }

    public int getEigenvaluesCount() {
        double[] values = this.decomposition.getRealEigenvalues();
        return values == null ? 0 : values.length;
    }

    public double getEigenvalue(int i) {
        return this.decomposition.getRealEigenvalue(i);
    }

    public double[] getEigenvalues() {
        return this.decomposition.getRealEigenvalues();
    }

    public double[] getEigenvector(int i) {
        return this.decomposition.getEigenvector(i).toArray();
    }

    public double getLargestEigenvalue() {
        double[] values = this.decomposition.getRealEigenvalues();
        double max = Double.MIN_VALUE;
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                max = Math.max(max, values[i]);
            }
        }
        return max;
    }

    public static void main(String ... args) {
        AdjacencyListGraph g = new AdjacencyListGraph("g");
        BarabasiAlbertGenerator gen = new BarabasiAlbertGenerator();
        gen.addSink((Sink)g);
        gen.begin();
        for (int i = 0; i < 200; ++i) {
            gen.nextEvents();
        }
        gen.end();
        Spectrum spectrum = new Spectrum();
        spectrum.init((Graph)g);
        spectrum.compute();
    }

    public static enum EigenValuesAlgorithm {
        POWER_ITERATION,
        INVERSE_ITERATION;

    }
}

