/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.algorithm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import org.graphstream.algorithm.AbstractSpanningTree;
import org.graphstream.algorithm.util.FibonacciHeap;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Node;
import org.graphstream.graph.Path;

public class Dijkstra
extends AbstractSpanningTree {
    protected Element element;
    protected String resultAttribute;
    protected String lengthAttribute;
    protected Node source;

    protected double getLength(Edge edge, Node dest) {
        double lenght = 0.0;
        if (this.element != Element.NODE) {
            lenght += this.lengthAttribute == null ? 1.0 : edge.getNumber(this.lengthAttribute);
        }
        if (this.element != Element.EDGE) {
            lenght += this.lengthAttribute == null ? 1.0 : dest.getNumber(this.lengthAttribute);
        }
        if (lenght < 0.0) {
            throw new IllegalStateException("Edge " + edge.getId() + " has negative lenght " + lenght);
        }
        return lenght;
    }

    protected double getSourceLength() {
        if (this.element == Element.EDGE) {
            return 0.0;
        }
        return this.lengthAttribute == null ? 1.0 : this.source.getNumber(this.lengthAttribute);
    }

    public Dijkstra(Element element, String resultAttribute, String lengthAttribute) {
        this(element, resultAttribute, lengthAttribute, null, null, null);
    }

    public Dijkstra() {
        this(null, null, null, null, null, null);
    }

    public Dijkstra(Element element, String resultAttribute, String lengthAttribute, String flagAttribute, Object flagOn, Object flagOff) {
        super(flagAttribute, flagOn, flagOff);
        this.element = element == null ? Element.EDGE : element;
        this.resultAttribute = resultAttribute == null ? this.toString() + "_result_" : resultAttribute;
        this.lengthAttribute = lengthAttribute;
        this.graph = null;
        this.source = null;
    }

    public <T extends Node> T getSource() {
        return (T)this.source;
    }

    public void setSource(Node source) {
        this.source = source;
    }

    @Override
    public void clear() {
        super.clear();
        for (Node node : this.graph) {
            Data data = (Data)node.getAttribute(this.resultAttribute);
            if (data != null) {
                data.fn = null;
                data.edgeFromParent = null;
            }
            node.removeAttribute(this.resultAttribute);
        }
    }

    @Override
    public void compute() {
        if (this.graph == null) {
            throw new IllegalStateException("No graph specified. Call init() first.");
        }
        if (this.source == null) {
            throw new IllegalStateException("No source specified. Call setSource() first.");
        }
        this.resetFlags();
        this.makeTree();
    }

    @Override
    protected void makeTree() {
        FibonacciHeap<Double, Node> heap = new FibonacciHeap<Double, Node>();
        for (Node node : this.graph) {
            Data data = new Data();
            double v = node == this.source ? this.getSourceLength() : Double.POSITIVE_INFINITY;
            data.fn = heap.add(v, node);
            data.edgeFromParent = null;
            node.addAttribute(this.resultAttribute, new Object[]{data});
        }
        while (!heap.isEmpty()) {
            Node u = (Node)heap.extractMin();
            Data dataU = (Data)u.getAttribute(this.resultAttribute);
            dataU.distance = (Double)dataU.fn.getKey();
            dataU.fn = null;
            if (dataU.edgeFromParent != null) {
                this.edgeOn(dataU.edgeFromParent);
            }
            for (Edge e : u.getEachLeavingEdge()) {
                double tryDist;
                Node v = e.getOpposite(u);
                Data dataV = (Data)v.getAttribute(this.resultAttribute);
                if (dataV.fn == null || !((tryDist = dataU.distance + this.getLength(e, v)) < (Double)dataV.fn.getKey())) continue;
                dataV.edgeFromParent = e;
                heap.decreaseKey(dataV.fn, tryDist);
            }
        }
    }

    public double getPathLength(Node target) {
        return ((Data)target.getAttribute((String)this.resultAttribute)).distance;
    }

    public double getTreeLength() {
        double length = this.getSourceLength();
        for (Edge edge : this.getTreeEdges()) {
            Node node = edge.getNode0();
            if (this.getEdgeFromParent(node) != edge) {
                node = edge.getNode1();
            }
            length += this.getLength(edge, node);
        }
        return length;
    }

    public <T extends Edge> T getEdgeFromParent(Node target) {
        return (T)((Data)target.getAttribute((String)this.resultAttribute)).edgeFromParent;
    }

    public <T extends Node> T getParent(Node target) {
        T edge = this.getEdgeFromParent(target);
        if (edge == null) {
            return null;
        }
        return (T)edge.getOpposite(target);
    }

    public <T extends Node> Iterator<T> getPathNodesIterator(Node target) {
        return new NodeIterator(target);
    }

    public <T extends Node> Iterable<T> getPathNodes(final Node target) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Dijkstra.this.getPathNodesIterator(target);
            }
        };
    }

    public <T extends Edge> Iterator<T> getPathEdgesIterator(Node target) {
        return new EdgeIterator(target);
    }

    public <T extends Edge> Iterable<T> getPathEdges(final Node target) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Dijkstra.this.getPathEdgesIterator(target);
            }
        };
    }

    public Iterator<Path> getAllPathsIterator(Node target) {
        return new PathIterator(target);
    }

    public Iterable<Path> getAllPaths(final Node target) {
        return new Iterable<Path>(){

            @Override
            public Iterator<Path> iterator() {
                return Dijkstra.this.getAllPathsIterator(target);
            }
        };
    }

    @Override
    public <T extends Edge> Iterator<T> getTreeEdgesIterator() {
        return new TreeIterator();
    }

    public Path getPath(Node target) {
        Path path = new Path();
        if (Double.isInfinite(this.getPathLength(target))) {
            return path;
        }
        Stack<Edge> stack = new Stack<Edge>();
        for (Edge e : this.getPathEdges(target)) {
            stack.push(e);
        }
        path.setRoot(this.source);
        while (!stack.isEmpty()) {
            path.add((Edge)stack.pop());
        }
        return path;
    }

    protected class TreeIterator<T extends Edge>
    implements Iterator<T> {
        Iterator<Node> nodeIt;
        T nextEdge;

        protected void findNextEdge() {
            this.nextEdge = null;
            while (this.nodeIt.hasNext() && this.nextEdge == null) {
                this.nextEdge = Dijkstra.this.getEdgeFromParent(this.nodeIt.next());
            }
        }

        protected TreeIterator() {
            this.nodeIt = Dijkstra.this.graph.getNodeIterator();
            this.findNextEdge();
        }

        @Override
        public boolean hasNext() {
            return this.nextEdge != null;
        }

        @Override
        public T next() {
            if (this.nextEdge == null) {
                throw new NoSuchElementException();
            }
            T edge = this.nextEdge;
            this.findNextEdge();
            return edge;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported by this iterator");
        }
    }

    protected class PathIterator
    implements Iterator<Path> {
        protected List<Node> nodes = new ArrayList<Node>();
        protected List<Iterator<Edge>> iterators = new ArrayList<Iterator<Edge>>();
        protected Path nextPath;

        protected void extendPathStep() {
            int last = this.nodes.size() - 1;
            Node v = this.nodes.get(last);
            double lengthV = Dijkstra.this.getPathLength(v);
            Iterator<Edge> it = this.iterators.get(last);
            while (it.hasNext()) {
                Edge e = it.next();
                Node u = e.getOpposite(v);
                if (Dijkstra.this.getPathLength(u) + Dijkstra.this.getLength(e, v) != lengthV) continue;
                this.nodes.add(u);
                this.iterators.add(u.getEnteringEdgeIterator());
                return;
            }
            this.nodes.remove(last);
            this.iterators.remove(last);
        }

        protected void extendPath() {
            while (!this.nodes.isEmpty() && this.nodes.get(this.nodes.size() - 1) != Dijkstra.this.source) {
                this.extendPathStep();
            }
        }

        protected void constructNextPath() {
            if (this.nodes.isEmpty()) {
                this.nextPath = null;
                return;
            }
            this.nextPath = new Path();
            this.nextPath.setRoot(Dijkstra.this.source);
            for (int i = this.nodes.size() - 1; i > 0; --i) {
                this.nextPath.add(this.nodes.get(i).getEdgeToward(this.nodes.get(i - 1).getId()));
            }
        }

        public PathIterator(Node target) {
            if (Double.isInfinite(Dijkstra.this.getPathLength(target))) {
                this.nextPath = null;
                return;
            }
            this.nodes.add(target);
            this.iterators.add(target.getEnteringEdgeIterator());
            this.extendPath();
            this.constructNextPath();
        }

        @Override
        public boolean hasNext() {
            return this.nextPath != null;
        }

        @Override
        public Path next() {
            if (this.nextPath == null) {
                throw new NoSuchElementException();
            }
            this.nodes.remove(this.nodes.size() - 1);
            this.iterators.remove(this.iterators.size() - 1);
            this.extendPath();
            Path path = this.nextPath;
            this.constructNextPath();
            return path;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported by this iterator");
        }
    }

    protected class EdgeIterator<T extends Edge>
    implements Iterator<T> {
        protected Node nextNode;
        protected T nextEdge;

        protected EdgeIterator(Node target) {
            this.nextNode = target;
            this.nextEdge = Dijkstra.this.getEdgeFromParent(this.nextNode);
        }

        @Override
        public boolean hasNext() {
            return this.nextEdge != null;
        }

        @Override
        public T next() {
            if (this.nextEdge == null) {
                throw new NoSuchElementException();
            }
            T edge = this.nextEdge;
            this.nextNode = Dijkstra.this.getParent(this.nextNode);
            this.nextEdge = Dijkstra.this.getEdgeFromParent(this.nextNode);
            return edge;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported by this iterator");
        }
    }

    protected class NodeIterator<T extends Node>
    implements Iterator<T> {
        protected Node nextNode;

        protected NodeIterator(Node target) {
            this.nextNode = Double.isInfinite(Dijkstra.this.getPathLength(target)) ? null : target;
        }

        @Override
        public boolean hasNext() {
            return this.nextNode != null;
        }

        @Override
        public T next() {
            if (this.nextNode == null) {
                throw new NoSuchElementException();
            }
            Node node = this.nextNode;
            this.nextNode = Dijkstra.this.getParent(this.nextNode);
            return (T)node;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported by this iterator");
        }
    }

    public static enum Element {
        EDGE,
        NODE,
        EDGE_AND_NODE;

    }

    protected static class Data {
        FibonacciHeap.Node fn;
        Edge edgeFromParent;
        double distance;

        protected Data() {
        }
    }
}

