/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.types;

import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;

public final class CoverageRange {
    private final int startOffset;
    private final int endOffset;
    private final long count;

    public CoverageRange(int startOffset, int endOffset, long count) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.count = count;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public long getCount() {
        return this.count;
    }

    private JSONObject toJSON() {
        JSONObject json = new JSONObject();
        json.put("startOffset", this.startOffset);
        json.put("endOffset", this.endOffset);
        json.put("count", this.count);
        return json;
    }

    static JSONArray toJSON(CoverageRange[] ranges) {
        JSONArray array = new JSONArray();
        for (CoverageRange range : ranges) {
            array.put((Object)range.toJSON());
        }
        return array;
    }
}

