/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.tools.chromeinspector.objects;

import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.tools.utils.json.JSONArray;
import com.oracle.truffle.tools.utils.json.JSONObject;

final class TruffleObject2JSON {
    private static final InteropLibrary INTEROP = (InteropLibrary)InteropLibrary.getFactory().getUncached();

    private TruffleObject2JSON() {
    }

    static JSONObject fromObject(Object object) {
        long size;
        Object keys;
        JSONObject json = new JSONObject();
        try {
            keys = INTEROP.getMembers(object);
        }
        catch (UnsupportedMessageException ex) {
            return json;
        }
        try {
            size = INTEROP.getArraySize(keys);
        }
        catch (UnsupportedMessageException ex) {
            return json;
        }
        if (size > 0L) {
            for (long i = 0L; i < size; ++i) {
                try {
                    Object key = INTEROP.readArrayElement(keys, i);
                    Object value = INTEROP.readMember(object, INTEROP.asString(key));
                    json.put(key.toString(), TruffleObject2JSON.from(value));
                    continue;
                }
                catch (InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException throwable) {
                    // empty catch block
                }
            }
        }
        return json;
    }

    static JSONArray fromArray(Object array) {
        long size;
        JSONArray json = new JSONArray();
        try {
            size = INTEROP.getArraySize(array);
        }
        catch (UnsupportedMessageException ex) {
            return json;
        }
        if (size > 0L) {
            for (long i = 0L; i < size; ++i) {
                try {
                    Object value = INTEROP.readArrayElement(array, i);
                    json.put((int)i, TruffleObject2JSON.from(value));
                    continue;
                }
                catch (InvalidArrayIndexException | UnsupportedMessageException ex) {
                    break;
                }
            }
        }
        return json;
    }

    private static Object from(Object object) {
        if (INTEROP.isString(object)) {
            try {
                return INTEROP.asString(object);
            }
            catch (UnsupportedMessageException e) {
                return object;
            }
        }
        if (INTEROP.hasArrayElements(object)) {
            return TruffleObject2JSON.fromArray(object);
        }
        if (INTEROP.hasMembers(object)) {
            return TruffleObject2JSON.fromObject(object);
        }
        return object;
    }
}

