/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.tck;

import java.util.Objects;
import java.util.function.Predicate;
import org.graalvm.polyglot.SourceSection;
import org.graalvm.polyglot.tck.ResultVerifier;
import org.graalvm.polyglot.tck.Snippet;

public final class InlineSnippet {
    private final Snippet script;
    private final Predicate<SourceSection> locationPredicate;
    private final CharSequence code;
    private final ResultVerifier verifier;

    private InlineSnippet(Snippet script, CharSequence source, Predicate<SourceSection> locationPredicate, ResultVerifier verifier) {
        this.script = script;
        this.code = source;
        this.locationPredicate = locationPredicate;
        this.verifier = verifier;
    }

    public Snippet getScript() {
        return this.script;
    }

    public CharSequence getCode() {
        return this.code;
    }

    public Predicate<SourceSection> getLocationPredicate() {
        return this.locationPredicate;
    }

    public ResultVerifier getResultVerifier() {
        return this.verifier;
    }

    public String toString() {
        return this.script.getId() + " : inline source";
    }

    public static Builder newBuilder(Snippet script, CharSequence code) {
        return new Builder(script, code);
    }

    public static final class Builder {
        private final Snippet script;
        private final CharSequence code;
        private Predicate<SourceSection> predicate;
        private ResultVerifier verifier;

        private Builder(Snippet script, CharSequence code) {
            Objects.requireNonNull(script);
            Objects.requireNonNull(code);
            this.script = script;
            this.code = code;
        }

        public Builder locationPredicate(Predicate<SourceSection> locationPredicate) {
            this.predicate = locationPredicate;
            return this;
        }

        public Builder resultVerifier(ResultVerifier resultVerifier) {
            this.verifier = resultVerifier;
            return this;
        }

        public InlineSnippet build() {
            return new InlineSnippet(this.script, this.code, this.predicate, this.verifier != null ? this.verifier : ResultVerifier.getDefaultResultVerifier());
        }
    }
}

