/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.tck;

import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.tck.ResultVerifier;
import org.graalvm.polyglot.tck.TypeDescriptor;

final class IdentityFunctionResultVerifier
implements ResultVerifier {
    static final ResultVerifier INSTANCE = new IdentityFunctionResultVerifier();

    private IdentityFunctionResultVerifier() {
    }

    @Override
    public void accept(ResultVerifier.SnippetRun snippetRun) throws PolyglotException {
        TypeDescriptor resultType;
        PolyglotException exception = snippetRun.getException();
        if (exception != null) {
            throw exception;
        }
        Value parameter = snippetRun.getParameters().get(0);
        TypeDescriptor parameterType = TypeDescriptor.forValue(parameter);
        if (!parameterType.isAssignable(resultType = TypeDescriptor.forValue(snippetRun.getResult())) || !resultType.isAssignable(resultType)) {
            throw new AssertionError((Object)String.format("Identity function result type must contain the parameter type. Parameter type: %s Result type: %s.", parameterType, resultType));
        }
    }
}

