/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.tck;

import org.graalvm.polyglot.PolyglotException;
import org.graalvm.polyglot.tck.ResultVerifier;
import org.graalvm.polyglot.tck.TypeDescriptor;

final class DefaultResultVerifier
implements ResultVerifier {
    static final ResultVerifier INSTANCE = new DefaultResultVerifier();

    private DefaultResultVerifier() {
    }

    @Override
    public void accept(ResultVerifier.SnippetRun snippetRun) throws PolyglotException {
        PolyglotException exception = snippetRun.getException();
        if (exception != null) {
            throw exception;
        }
        TypeDescriptor resultType = TypeDescriptor.forValue(snippetRun.getResult());
        TypeDescriptor snippetReturnType = snippetRun.getSnippet().getReturnType();
        if (!snippetReturnType.isAssignable(resultType)) {
            throw new AssertionError((Object)String.format("Result is out of type bounds. Expected: %s, Got: %s.", snippetReturnType, resultType));
        }
    }
}

