/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.serialize.hosted;

import com.oracle.svm.core.jdk.Package_jdk_internal_reflect;
import com.oracle.svm.core.jdk.serialize.SerializationRegistry;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.reflect.serialize.SerializationSupport;
import com.oracle.svm.reflect.serialize.hosted.SerializationFeature;
import com.oracle.svm.util.ReflectionUtil;
import com.oracle.svm.util.SerializationChecksumCalculator;
import java.io.Externalizable;
import java.io.ObjectStreamClass;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;

final class SerializationBuilder {
    private final SerializationChecksumClassLoader serializationChecksumClassLoader;
    private final ChecksumCalculator checksumCalculator;
    private final FeatureImpl.BeforeAnalysisAccessImpl access;
    private final Object reflectionFactory;
    private final Method newConstructorForSerializationMethod;
    private final Method getConstructorAccessorMethod;
    private final Method getExternalizableConstructorMethod;
    private final Constructor<?> stubConstructor;
    private final SerializationSupport serializationSupport;

    SerializationBuilder(FeatureImpl.BeforeAnalysisAccessImpl access) {
        try {
            Class<?> reflectionFactoryClass = access.findClassByName(Package_jdk_internal_reflect.getQualifiedName() + ".ReflectionFactory");
            Method getReflectionFactoryMethod = ReflectionUtil.lookupMethod(reflectionFactoryClass, (String)"getReflectionFactory", (Class[])new Class[0]);
            this.reflectionFactory = getReflectionFactoryMethod.invoke(null, new Object[0]);
            this.newConstructorForSerializationMethod = ReflectionUtil.lookupMethod(reflectionFactoryClass, (String)"newConstructorForSerialization", (Class[])new Class[]{Class.class});
            this.getConstructorAccessorMethod = ReflectionUtil.lookupMethod(Constructor.class, (String)"getConstructorAccessor", (Class[])new Class[0]);
            this.getExternalizableConstructorMethod = ReflectionUtil.lookupMethod(ObjectStreamClass.class, (String)"getExternalizableConstructor", (Class[])new Class[]{Class.class});
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
        this.stubConstructor = this.newConstructorForSerialization(SerializationSupport.StubForAbstractClass.class);
        this.access = access;
        URLClassLoader cl = (URLClassLoader)access.getImageClassLoader().getClassLoader();
        this.serializationChecksumClassLoader = new SerializationChecksumClassLoader(cl.getURLs(), cl.getParent());
        this.checksumCalculator = new ChecksumCalculator();
        this.serializationSupport = new SerializationSupport();
        ImageSingletons.add(SerializationRegistry.class, (Object)this.serializationSupport);
    }

    private Constructor<?> newConstructorForSerialization(Class<?> serializationTargetClass) {
        try {
            return (Constructor)this.newConstructorForSerializationMethod.invoke(this.reflectionFactory, serializationTargetClass);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private Object getConstructorAccessor(Constructor<?> constructor) {
        try {
            return this.getConstructorAccessorMethod.invoke(constructor, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private Constructor<?> getExternalizableConstructor(Class<?> serializationTargetClass) {
        try {
            return (Constructor)this.getExternalizableConstructorMethod.invoke(null, serializationTargetClass);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    Class<?> addConstructorAccessor(Class<?> serializationTargetClass, List<String> configuredChecksums) {
        Class<?> targetConstructorClass;
        Constructor<?> targetConstructor;
        if (serializationTargetClass.isArray() || Enum.class.isAssignableFrom(serializationTargetClass)) {
            return null;
        }
        if (Externalizable.class.isAssignableFrom(serializationTargetClass)) {
            try {
                Constructor<?> externalizableConstructor = this.getExternalizableConstructor(serializationTargetClass);
                return externalizableConstructor.getDeclaringClass();
            }
            catch (Exception e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
        if (Modifier.isAbstract(serializationTargetClass.getModifiers())) {
            targetConstructor = this.stubConstructor;
            targetConstructorClass = targetConstructor.getDeclaringClass();
        } else {
            targetConstructor = this.newConstructorForSerialization(serializationTargetClass);
            targetConstructorClass = targetConstructor.getDeclaringClass();
            this.verifyBuildTimeChecksum(serializationTargetClass, targetConstructorClass, configuredChecksums);
        }
        this.serializationSupport.addConstructorAccessor(serializationTargetClass, targetConstructorClass, this.getConstructorAccessor(targetConstructor));
        return targetConstructorClass;
    }

    private void verifyBuildTimeChecksum(Class<?> serializationTargetClass, Class<?> targetConstructorClass, List<String> configuredChecksums) {
        if (configuredChecksums.isEmpty()) {
            return;
        }
        try {
            String targetClassName = serializationTargetClass.getName();
            Class<?> checksumCalculationTargetClass = Class.forName(targetClassName, false, this.serializationChecksumClassLoader);
            String buildTimeChecksum = this.checksumCalculator.calculateChecksum(targetConstructorClass.getName(), targetClassName, checksumCalculationTargetClass);
            if (!configuredChecksums.contains(buildTimeChecksum)) {
                String msg = "\nBuild time serialization class checksum verify failure. The classes' hierarchy may have been changed from configuration collecting time to image build time:\n" + targetClassName + ": configured checksums: " + String.join((CharSequence)", ", configuredChecksums) + "\n" + targetClassName + ": build time checksum: " + buildTimeChecksum;
                this.reportChecksumError(msg);
            }
        }
        catch (ClassNotFoundException | NoSuchAlgorithmException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private void reportChecksumError(String exceptionsMsg) {
        String option = SubstrateOptionsParser.commandArgument(NativeImageOptions.ReportUnsupportedElementsAtRuntime, "+");
        if (!NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue()) {
            this.access.getBigBang().getUnsupportedFeatures().addMessage("CHECKSUM_VERIFY_FAIL", null, exceptionsMsg + "\nTo allow continuing compilation with above unsupported features, set " + option);
        } else {
            SerializationFeature.println(exceptionsMsg);
            SerializationFeature.println("Compilation will continue because " + option + " was set. But the program may behave unexpectedly at runtime.");
        }
    }

    private static final class ChecksumCalculator
    extends SerializationChecksumCalculator.JavaCalculator {
        private final Method computeDefaultSUID = ReflectionUtil.lookupMethod(ObjectStreamClass.class, (String)"computeDefaultSUID", (Class[])new Class[]{Class.class});

        private ChecksumCalculator() {
        }

        protected String getClassName(Class<?> clazz) {
            return clazz.getName();
        }

        protected Class<?> getSuperClass(Class<?> clazz) {
            return clazz.getSuperclass();
        }

        protected Long calculateFromComputeDefaultSUID(Class<?> clazz) {
            try {
                return (Long)this.computeDefaultSUID.invoke(null, clazz);
            }
            catch (ReflectiveOperationException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }

        protected boolean isClassAbstract(Class<?> clazz) {
            return Modifier.isAbstract(clazz.getModifiers());
        }
    }

    private static final class SerializationChecksumClassLoader
    extends URLClassLoader {
        private SerializationChecksumClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }
    }
}

